/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.security.MuleCredentials;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class PlainTextFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    public PlainTextFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "encryption-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "encryption-test-flow.xml"});
    }

    @Test
    public void testAuthenticationFailureNoContext() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage m = client.send(this.getUrl(), this.getTestMuleMessage());
        Assert.assertNotNull((Object)m);
        int status = (Integer)m.getInboundProperty("http.status", (Object)-1);
        Assert.assertEquals((long)401L, (long)status);
    }

    @Test
    public void testAuthenticationFailureBadCredentials() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = this.createRequestMessage("anonX", "anonX");
        MuleMessage response = client.send(this.getUrl(), message);
        Assert.assertNotNull((Object)response);
        int status = (Integer)response.getInboundProperty("http.status", (Object)-1);
        Assert.assertEquals((long)401L, (long)status);
    }

    @Test
    public void testAuthenticationAuthorised() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = this.createRequestMessage("anon", "anon");
        MuleMessage response = client.send(this.getUrl(), message);
        Assert.assertNotNull((Object)response);
        int status = (Integer)response.getInboundProperty("http.status", (Object)-1);
        Assert.assertEquals((long)200L, (long)status);
    }

    private MuleMessage createRequestMessage(String user, String password) {
        MuleMessage message = this.getTestMuleMessage();
        String header = MuleCredentials.createHeader((String)user, (char[])password.toCharArray());
        message.setOutboundProperty("MULE_USER", (Object)header);
        return message;
    }

    private String getUrl() {
        return String.format("http://localhost:%s/index.html", this.port1.getNumber());
    }
}

