/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.SecurityNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.SecurityNotification;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.concurrent.Latch;

public class SecureHttpPollingFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    public SecureHttpPollingFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "secure-http-polling-server-service.xml,secure-http-polling-client-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "secure-http-polling-server-flow.xml,secure-http-polling-client-flow.xml"});
    }

    @Test
    public void testPollingHttpConnectorSentCredentials() throws Exception {
        final Latch latch = new Latch();
        muleContext.registerListener((ServerNotificationListener)new SecurityNotificationListener<SecurityNotification>(){

            public void onNotification(SecurityNotification notification) {
                latch.countDown();
            }
        });
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.request("vm://toclient", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"foo", (Object)result.getPayloadAsString());
        result = client.request("vm://toclient2", 1000L);
        Assert.assertNotNull((Object)result);
        int status = (Integer)result.getInboundProperty("http.status", (Object)0);
        Assert.assertEquals((long)401L, (long)status);
        Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
    }
}

