/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class SecurityContextSerializationTestCase
extends FunctionalTestCase {
    private final String configFile;
    @Rule
    public DynamicPort httpPort = new DynamicPort("port1");

    public SecurityContextSerializationTestCase(String configFile) {
        this.configFile = configFile;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"http-transport-security-context-serialization-test-case.xml"}, {"http-module-security-context-serialization-test-case.xml"});
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void testAuthorizedInAnotherFlow() throws Exception {
        this.doRequest(null, "localhost", "ross", "ross", this.getUrl(), false, 200);
    }

    protected String getUrl() {
        return String.format("http://localhost:%s/authorize", this.httpPort.getNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(String realm, String host, String user, String pass, String url, boolean handshake, int result) throws Exception {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        client.getState().setCredentials(new AuthScope(host, -1, realm), (Credentials)new UsernamePasswordCredentials(user, pass));
        GetMethod get = new GetMethod(url);
        get.setDoAuthentication(handshake);
        try {
            int status = client.executeMethod((HttpMethod)get);
            if (status == 401 && handshake && (status = client.executeMethod((HttpMethod)get)) == 401 && handshake) {
                status = client.executeMethod((HttpMethod)get);
            }
            Assert.assertEquals((long)result, (long)status);
        }
        finally {
            get.releaseConnection();
        }
    }

    public static class AddNotSerializableProperty
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            event.getMessage().setInvocationProperty("notSerializableProperty", new Object());
            return event;
        }
    }
}

