/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.security.SecurityManager;
import org.mule.api.security.SecurityProvider;
import org.mule.module.spring.security.SpringProviderAdapter;
import org.mule.tck.junit4.FunctionalTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringSecurityNamespaceHandlerTestCase
extends FunctionalTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringSecurityNamespaceHandlerTestCase.class);

    protected String getConfigFile() {
        return "spring-security-namespace-config.xml";
    }

    @Test
    public void testProvider() {
        this.knownProperties(this.getProvider("memory-dao"));
    }

    protected SecurityProvider getProvider(String providerName) {
        SecurityManager securityManager = muleContext.getSecurityManager();
        return securityManager.getProvider(providerName);
    }

    @Test
    public void testCustom() {
        for (SecurityProvider provider : muleContext.getSecurityManager().getProviders()) {
            LOGGER.debug(String.valueOf(provider));
            LOGGER.debug(provider.getName());
        }
        this.knownProperties(this.getProvider("customProvider"));
        this.knownProperties(this.getProvider("willOverwriteName"));
    }

    protected void knownProperties(SecurityProvider provider) {
        Assert.assertNotNull((Object)provider);
        Assert.assertTrue((boolean)(provider instanceof SpringProviderAdapter));
        SpringProviderAdapter adapter = (SpringProviderAdapter)provider;
        Assert.assertNotNull((Object)adapter.getDelegate());
    }
}

