/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.spring.security;

import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.extensions.UsesHttpExtensionFunctionalTestCase;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.runtime.core.security.DefaultMuleSecurityManager;
import org.mule.runtime.module.spring.security.PreAuthenticatedAuthenticationProvider;
import org.mule.runtime.module.spring.security.SpringProviderAdapter;
import org.mule.runtime.module.spring.security.UserAndPasswordAuthenticationProvider;

public abstract class AuthenticationNamespaceHandlerTestCase
extends UsesHttpExtensionFunctionalTestCase {
    @Test
    public void testSecurityManagerConfigured() {
        DefaultMuleSecurityManager securityManager = (DefaultMuleSecurityManager)muleContext.getRegistry().lookupObject("_muleSecurityManager");
        Assert.assertNotNull((Object)securityManager);
        Collection providers = securityManager.getProviders();
        Assert.assertEquals((long)2L, (long)providers.size());
        Assert.assertThat((Object)this.containsSecurityProvider(providers, UserAndPasswordAuthenticationProvider.class), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.containsSecurityProvider(providers, PreAuthenticatedAuthenticationProvider.class), (Matcher)Matchers.is((Object)true));
    }

    private boolean containsSecurityProvider(Collection<SecurityProvider> providers, Class authenticationProviderClass) {
        for (SecurityProvider provider : providers) {
            Assert.assertEquals(SpringProviderAdapter.class, provider.getClass());
            if (!authenticationProviderClass.equals(((SpringProviderAdapter)provider).getAuthenticationProvider().getClass())) continue;
            return true;
        }
        return false;
    }
}

