/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.spring.security;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.FunctionalTestCase;
import org.mule.runtime.core.api.client.MuleClient;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.security.DefaultMuleCredentials;
import org.mule.service.http.api.HttpConstants;
import org.mule.tck.junit4.rule.DynamicPort;

@Ignore(value="See MULE-9202")
public class PlainTextFunctionalTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    protected String getConfigFile() {
        return "encryption-test-flow.xml";
    }

    @Test
    public void testAuthenticationFailureNoContext() throws Exception {
        MuleClient client = muleContext.getClient();
        InternalMessage m = (InternalMessage)client.send(this.getUrl(), InternalMessage.of((Object)"test")).getRight();
        Assert.assertNotNull((Object)m);
        int status = (Integer)m.getInboundProperty("http.status", (Serializable)Integer.valueOf(-1));
        Assert.assertEquals((long)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode(), (long)status);
    }

    @Test
    public void testAuthenticationFailureBadCredentials() throws Exception {
        MuleClient client = muleContext.getClient();
        InternalMessage message = this.createRequestMessage("anonX", "anonX");
        InternalMessage response = (InternalMessage)client.send(this.getUrl(), message).getRight();
        Assert.assertNotNull((Object)response);
        int status = (Integer)response.getInboundProperty("http.status", (Serializable)Integer.valueOf(-1));
        Assert.assertEquals((long)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode(), (long)status);
    }

    @Test
    public void testAuthenticationAuthorised() throws Exception {
        MuleClient client = muleContext.getClient();
        InternalMessage message = this.createRequestMessage("anon", "anon");
        InternalMessage response = (InternalMessage)client.send(this.getUrl(), message).getRight();
        Assert.assertNotNull((Object)response);
        int status = (Integer)response.getInboundProperty("http.status", (Serializable)Integer.valueOf(-1));
        Assert.assertEquals((Object)HttpConstants.HttpStatus.OK, (Object)status);
    }

    private InternalMessage createRequestMessage(String user, String password) {
        String header = DefaultMuleCredentials.createHeader((String)user, (char[])password.toCharArray());
        return InternalMessage.builder().payload((Object)"test").addOutboundProperty("MULE_USER", (Serializable)((Object)header)).build();
    }

    private String getUrl() {
        return String.format("http://localhost:%s/index.html", this.port1.getNumber());
    }
}

