/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.workday.absence.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.workday.absence.adapters.AbsenceModuleLicenseChecker;
import org.mule.modules.workday.absence.connectivity.AbsenceModuleConnectionKey;
import org.mule.modules.workday.absence.connectivity.AbsenceModuleConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbsenceModuleConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(AbsenceModuleConnectionFactory.class);
    private AbsenceModuleConnectionManager connectionManager;

    public AbsenceModuleConnectionFactory(AbsenceModuleConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof AbsenceModuleConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.workday.absence.connectivity.AbsenceModuleConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        AbsenceModuleLicenseChecker connector = new AbsenceModuleLicenseChecker();
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.validateConnection()) {
            connector.connect(((AbsenceModuleConnectionKey)key).getAbsenceUser(), ((AbsenceModuleConnectionKey)key).getAbsencePassword(), ((AbsenceModuleConnectionKey)key).getAbsenceEndpoint(), ((AbsenceModuleConnectionKey)key).getAbsenceWsdlLocation());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof AbsenceModuleConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.workday.absence.connectivity.AbsenceModuleConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof AbsenceModuleLicenseChecker)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.workday.absence.adapters.AbsenceModuleLicenseChecker")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((AbsenceModuleLicenseChecker)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((AbsenceModuleLicenseChecker)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((AbsenceModuleLicenseChecker)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof AbsenceModuleLicenseChecker)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.workday.absence.adapters.AbsenceModuleLicenseChecker")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((AbsenceModuleLicenseChecker)obj).validateConnection();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof AbsenceModuleConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof AbsenceModuleLicenseChecker)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((AbsenceModuleLicenseChecker)obj).validateConnection()) {
            ((AbsenceModuleLicenseChecker)obj).connect(((AbsenceModuleConnectionKey)key).getAbsenceUser(), ((AbsenceModuleConnectionKey)key).getAbsencePassword(), ((AbsenceModuleConnectionKey)key).getAbsenceEndpoint(), ((AbsenceModuleConnectionKey)key).getAbsenceWsdlLocation());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

