/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.workday.absence.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.config.PoolingProfile;
import org.mule.modules.workday.absence.adapters.AbsenceModuleLicenseChecker;
import org.mule.modules.workday.absence.basic.Capabilities;
import org.mule.modules.workday.absence.basic.Capability;
import org.mule.modules.workday.absence.basic.MetadataAware;
import org.mule.modules.workday.absence.connection.ConnectionManager;
import org.mule.modules.workday.absence.connectivity.AbsenceModuleConnectionFactory;
import org.mule.modules.workday.absence.connectivity.AbsenceModuleConnectionKey;
import org.mule.modules.workday.absence.connectivity.AbsenceModuleManagedConnectionProcessTemplate;
import org.mule.modules.workday.absence.process.ProcessAdapter;
import org.mule.modules.workday.absence.process.ProcessTemplate;

public class AbsenceModuleConnectionManager
implements MuleContextAware,
Disposable,
Initialisable,
Testable,
Capabilities,
MetadataAware,
ConnectionManager<AbsenceModuleConnectionKey, AbsenceModuleLicenseChecker>,
ProcessAdapter<AbsenceModuleLicenseChecker> {
    private String absenceUser;
    private String absencePassword;
    private String absenceEndpoint;
    private String absenceWsdlLocation;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Workday Absence Management";
    private static final String MODULE_VERSION = "4.2.0-SNAPSHOT";
    private static final String DEVKIT_VERSION = "3.4.3";
    private static final String DEVKIT_BUILD = "3.4.3.1620.30ea288";

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    @Override
    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setAbsenceWsdlLocation(String value) {
        this.absenceWsdlLocation = value;
    }

    public String getAbsenceWsdlLocation() {
        return this.absenceWsdlLocation;
    }

    public void setAbsenceEndpoint(String value) {
        this.absenceEndpoint = value;
    }

    public String getAbsenceEndpoint() {
        return this.absenceEndpoint;
    }

    public void setAbsenceUser(String value) {
        this.absenceUser = value;
    }

    public String getAbsenceUser() {
        return this.absenceUser;
    }

    public void setAbsencePassword(String value) {
        this.absencePassword = value;
    }

    public String getAbsencePassword() {
        return this.absencePassword;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (this.connectionPoolingProfile != null) {
            config.maxIdle = this.connectionPoolingProfile.getMaxIdle();
            config.maxActive = this.connectionPoolingProfile.getMaxActive();
            config.maxWait = this.connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = (byte)this.connectionPoolingProfile.getExhaustedAction();
            config.timeBetweenEvictionRunsMillis = this.connectionPoolingProfile.getEvictionCheckIntervalMillis();
            config.minEvictableIdleTimeMillis = this.connectionPoolingProfile.getMinEvictionMillis();
        }
        this.connectionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new AbsenceModuleConnectionFactory(this), config);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public void dispose() {
        try {
            this.connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public AbsenceModuleLicenseChecker acquireConnection(AbsenceModuleConnectionKey key) throws Exception {
        return (AbsenceModuleLicenseChecker)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(AbsenceModuleConnectionKey key, AbsenceModuleLicenseChecker connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(AbsenceModuleConnectionKey key, AbsenceModuleLicenseChecker connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    @Override
    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == Capability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    @Override
    public <P> ProcessTemplate<P, AbsenceModuleLicenseChecker> getProcessTemplate() {
        return new AbsenceModuleManagedConnectionProcessTemplate(this, this.muleContext);
    }

    @Override
    public AbsenceModuleConnectionKey getDefaultConnectionKey() {
        return new AbsenceModuleConnectionKey(this.getAbsenceUser(), this.getAbsencePassword(), this.getAbsenceEndpoint(), this.getAbsenceWsdlLocation());
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    @Override
    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    @Override
    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        DefaultTestResult result;
        AbsenceModuleLicenseChecker connection = null;
        AbsenceModuleConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception ie) {
                // empty catch block
            }
            result = (DefaultTestResult)this.buildFailureTestResult(e);
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
        return result;
    }

    public DefaultResult buildFailureTestResult(Exception exception) {
        ConnectionExceptionCode code;
        DefaultTestResult result = exception instanceof ConnectionException ? ((code = ((ConnectionException)exception).getCode()) == ConnectionExceptionCode.UNKNOWN_HOST ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNKNOWN_HOST, (Throwable)exception) : (code == ConnectionExceptionCode.CANNOT_REACH ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.RESOURCE_UNAVAILABLE, (Throwable)exception) : (code == ConnectionExceptionCode.INCORRECT_CREDENTIALS ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.CREDENTIALS_EXPIRED ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.UNKNOWN ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception)))))) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception);
        return result;
    }
}

