/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.workday.absence.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.workday.absence.adapters.AbsenceModuleConnectionIdentifierAdapter;
import org.mule.modules.workday.absence.connection.ConnectionManager;
import org.mule.modules.workday.absence.connection.UnableToAcquireConnectionException;
import org.mule.modules.workday.absence.connection.UnableToReleaseConnectionException;
import org.mule.modules.workday.absence.connectivity.AbsenceModuleConnectionKey;
import org.mule.modules.workday.absence.process.ProcessCallback;
import org.mule.modules.workday.absence.process.ProcessInterceptor;
import org.mule.modules.workday.absence.processors.AbstractConnectedProcessor;
import org.mule.modules.workday.absence.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbsenceModuleManagedConnectionProcessInterceptor<T>
extends AbstractExpressionEvaluator
implements ProcessInterceptor<T, AbsenceModuleConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(AbsenceModuleManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<AbsenceModuleConnectionKey, AbsenceModuleConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, AbsenceModuleConnectionIdentifierAdapter> next;

    public AbsenceModuleManagedConnectionProcessInterceptor(ProcessInterceptor<T, AbsenceModuleConnectionIdentifierAdapter> next, ConnectionManager<AbsenceModuleConnectionKey, AbsenceModuleConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    @Override
    public T execute(ProcessCallback<T, AbsenceModuleConnectionIdentifierAdapter> processCallback, AbsenceModuleConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        String _transformedAbsenceUser;
        AbsenceModuleConnectionIdentifierAdapter connection = null;
        AbsenceModuleConnectionKey key = null;
        if (messageProcessor != null && messageProcessor instanceof AbstractConnectedProcessor && ((AbstractConnectedProcessor)messageProcessor).getAbsenceUser() != null) {
            _transformedAbsenceUser = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_absenceUserType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getAbsenceUser());
            if (_transformedAbsenceUser == null) {
                throw new UnableToAcquireConnectionException("Parameter absenceUser in method connect can't be null because is not @Optional");
            }
            String _transformedAbsencePassword = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_absencePasswordType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getAbsencePassword());
            if (_transformedAbsencePassword == null) {
                throw new UnableToAcquireConnectionException("Parameter absencePassword in method connect can't be null because is not @Optional");
            }
            String _transformedAbsenceEndpoint = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_absenceEndpointType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getAbsenceEndpoint());
            if (_transformedAbsenceEndpoint == null) {
                throw new UnableToAcquireConnectionException("Parameter absenceEndpoint in method connect can't be null because is not @Optional");
            }
            String _transformedAbsenceWsdlLocation = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_absenceWsdlLocationType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getAbsenceWsdlLocation());
            key = new AbsenceModuleConnectionKey(_transformedAbsenceUser, _transformedAbsencePassword, _transformedAbsenceEndpoint, _transformedAbsenceWsdlLocation);
        } else {
            key = this.connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = this.connectionManager.acquireConnection(key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            _transformedAbsenceUser = this.next.execute(processCallback, connection, messageProcessor, event);
            return (T)_transformedAbsenceUser;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        if (connection == null) continue;
                        this.connectionManager.destroyConnection(key, connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection(key, connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    @Override
    public T execute(ProcessCallback<T, AbsenceModuleConnectionIdentifierAdapter> processCallback, AbsenceModuleConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

