/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.workday.payrollinterface.adapters;

import com.mulesource.licm.EnterpriseLicenseKey;
import com.mulesource.licm.LicenseKeyException;
import com.mulesource.licm.LicenseManagementFactory;
import com.mulesource.licm.LicenseManager;
import java.util.Calendar;
import java.util.Date;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.modules.workday.payrollinterface.adapters.PayrollInterfaceModuleConnectionIdentifierAdapter;

public class PayrollInterfaceModuleLicenseChecker
extends PayrollInterfaceModuleConnectionIdentifierAdapter
implements Initialisable {
    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.checkMuleLicense();
    }

    private void checkMuleLicense() {
        try {
            LicenseManager licenseManager = LicenseManagementFactory.getInstance().createLicenseManager("mule-ee");
            EnterpriseLicenseKey license = licenseManager.validate("mule-ee");
            Calendar expirationDate = Calendar.getInstance();
            if (license.getExpirationDate() != null) {
                expirationDate.setTime(license.getExpirationDate());
                if (expirationDate.after(new Date())) {
                    throw new RuntimeException("Your license has expire");
                }
            }
            if (license.isEvaluation()) {
                throw new RuntimeException("This Module does not allow Evaluation Licenses.");
            }
        }
        catch (LicenseKeyException _x) {
            throw new RuntimeException("This Module requires an Enterprise license");
        }
    }
}

