/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.workday.payrollinterface.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.workday.payrollinterface.adapters.PayrollInterfaceModuleLicenseChecker;
import org.mule.modules.workday.payrollinterface.connectivity.PayrollInterfaceModuleConnectionKey;
import org.mule.modules.workday.payrollinterface.connectivity.PayrollInterfaceModuleConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayrollInterfaceModuleConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(PayrollInterfaceModuleConnectionFactory.class);
    private PayrollInterfaceModuleConnectionManager connectionManager;

    public PayrollInterfaceModuleConnectionFactory(PayrollInterfaceModuleConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof PayrollInterfaceModuleConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.workday.payrollinterface.connectivity.PayrollInterfaceModuleConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        PayrollInterfaceModuleLicenseChecker connector = new PayrollInterfaceModuleLicenseChecker();
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.validateConnection()) {
            connector.connect(((PayrollInterfaceModuleConnectionKey)key).getPayrollInterfaceUser(), ((PayrollInterfaceModuleConnectionKey)key).getPayrollInterfacePassword(), ((PayrollInterfaceModuleConnectionKey)key).getPayrollInterfaceEndpoint(), ((PayrollInterfaceModuleConnectionKey)key).getPayrollInterfaceWsdlLocation());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof PayrollInterfaceModuleConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.workday.payrollinterface.connectivity.PayrollInterfaceModuleConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof PayrollInterfaceModuleLicenseChecker)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.workday.payrollinterface.adapters.PayrollInterfaceModuleLicenseChecker")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((PayrollInterfaceModuleLicenseChecker)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((PayrollInterfaceModuleLicenseChecker)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((PayrollInterfaceModuleLicenseChecker)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof PayrollInterfaceModuleLicenseChecker)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.workday.payrollinterface.adapters.PayrollInterfaceModuleLicenseChecker")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((PayrollInterfaceModuleLicenseChecker)obj).validateConnection();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof PayrollInterfaceModuleConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof PayrollInterfaceModuleLicenseChecker)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((PayrollInterfaceModuleLicenseChecker)obj).validateConnection()) {
            ((PayrollInterfaceModuleLicenseChecker)obj).connect(((PayrollInterfaceModuleConnectionKey)key).getPayrollInterfaceUser(), ((PayrollInterfaceModuleConnectionKey)key).getPayrollInterfacePassword(), ((PayrollInterfaceModuleConnectionKey)key).getPayrollInterfaceEndpoint(), ((PayrollInterfaceModuleConnectionKey)key).getPayrollInterfaceWsdlLocation());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

