/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.workday.payrollinterface.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.config.PoolingProfile;
import org.mule.modules.workday.payrollinterface.adapters.PayrollInterfaceModuleLicenseChecker;
import org.mule.modules.workday.payrollinterface.basic.Capabilities;
import org.mule.modules.workday.payrollinterface.basic.Capability;
import org.mule.modules.workday.payrollinterface.basic.MetadataAware;
import org.mule.modules.workday.payrollinterface.connection.ConnectionManager;
import org.mule.modules.workday.payrollinterface.connectivity.PayrollInterfaceModuleConnectionFactory;
import org.mule.modules.workday.payrollinterface.connectivity.PayrollInterfaceModuleConnectionKey;
import org.mule.modules.workday.payrollinterface.connectivity.PayrollInterfaceModuleManagedConnectionProcessTemplate;
import org.mule.modules.workday.payrollinterface.process.ProcessAdapter;
import org.mule.modules.workday.payrollinterface.process.ProcessTemplate;

public class PayrollInterfaceModuleConnectionManager
implements MuleContextAware,
Disposable,
Initialisable,
Testable,
Capabilities,
MetadataAware,
ConnectionManager<PayrollInterfaceModuleConnectionKey, PayrollInterfaceModuleLicenseChecker>,
ProcessAdapter<PayrollInterfaceModuleLicenseChecker> {
    private String payrollInterfaceUser;
    private String payrollInterfacePassword;
    private String payrollInterfaceEndpoint;
    private String payrollInterfaceWsdlLocation;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Workday Payroll Interface";
    private static final String MODULE_VERSION = "4.2.0-SNAPSHOT";
    private static final String DEVKIT_VERSION = "3.4.3";
    private static final String DEVKIT_BUILD = "3.4.3.1620.30ea288";

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    @Override
    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setPayrollInterfaceEndpoint(String value) {
        this.payrollInterfaceEndpoint = value;
    }

    public String getPayrollInterfaceEndpoint() {
        return this.payrollInterfaceEndpoint;
    }

    public void setPayrollInterfacePassword(String value) {
        this.payrollInterfacePassword = value;
    }

    public String getPayrollInterfacePassword() {
        return this.payrollInterfacePassword;
    }

    public void setPayrollInterfaceWsdlLocation(String value) {
        this.payrollInterfaceWsdlLocation = value;
    }

    public String getPayrollInterfaceWsdlLocation() {
        return this.payrollInterfaceWsdlLocation;
    }

    public void setPayrollInterfaceUser(String value) {
        this.payrollInterfaceUser = value;
    }

    public String getPayrollInterfaceUser() {
        return this.payrollInterfaceUser;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (this.connectionPoolingProfile != null) {
            config.maxIdle = this.connectionPoolingProfile.getMaxIdle();
            config.maxActive = this.connectionPoolingProfile.getMaxActive();
            config.maxWait = this.connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = (byte)this.connectionPoolingProfile.getExhaustedAction();
            config.timeBetweenEvictionRunsMillis = this.connectionPoolingProfile.getEvictionCheckIntervalMillis();
            config.minEvictableIdleTimeMillis = this.connectionPoolingProfile.getMinEvictionMillis();
        }
        this.connectionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new PayrollInterfaceModuleConnectionFactory(this), config);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public void dispose() {
        try {
            this.connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public PayrollInterfaceModuleLicenseChecker acquireConnection(PayrollInterfaceModuleConnectionKey key) throws Exception {
        return (PayrollInterfaceModuleLicenseChecker)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(PayrollInterfaceModuleConnectionKey key, PayrollInterfaceModuleLicenseChecker connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(PayrollInterfaceModuleConnectionKey key, PayrollInterfaceModuleLicenseChecker connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    @Override
    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == Capability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    @Override
    public <P> ProcessTemplate<P, PayrollInterfaceModuleLicenseChecker> getProcessTemplate() {
        return new PayrollInterfaceModuleManagedConnectionProcessTemplate(this, this.muleContext);
    }

    @Override
    public PayrollInterfaceModuleConnectionKey getDefaultConnectionKey() {
        return new PayrollInterfaceModuleConnectionKey(this.getPayrollInterfaceUser(), this.getPayrollInterfacePassword(), this.getPayrollInterfaceEndpoint(), this.getPayrollInterfaceWsdlLocation());
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    @Override
    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    @Override
    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        DefaultTestResult result;
        PayrollInterfaceModuleLicenseChecker connection = null;
        PayrollInterfaceModuleConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception ie) {
                // empty catch block
            }
            result = (DefaultTestResult)this.buildFailureTestResult(e);
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
        return result;
    }

    public DefaultResult buildFailureTestResult(Exception exception) {
        ConnectionExceptionCode code;
        DefaultTestResult result = exception instanceof ConnectionException ? ((code = ((ConnectionException)exception).getCode()) == ConnectionExceptionCode.UNKNOWN_HOST ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNKNOWN_HOST, (Throwable)exception) : (code == ConnectionExceptionCode.CANNOT_REACH ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.RESOURCE_UNAVAILABLE, (Throwable)exception) : (code == ConnectionExceptionCode.INCORRECT_CREDENTIALS ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.CREDENTIALS_EXPIRED ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.UNKNOWN ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception)))))) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception);
        return result;
    }
}

