/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.workday.payrollinterface.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.workday.payrollinterface.adapters.PayrollInterfaceModuleConnectionIdentifierAdapter;
import org.mule.modules.workday.payrollinterface.connection.ConnectionManager;
import org.mule.modules.workday.payrollinterface.connection.UnableToAcquireConnectionException;
import org.mule.modules.workday.payrollinterface.connection.UnableToReleaseConnectionException;
import org.mule.modules.workday.payrollinterface.connectivity.PayrollInterfaceModuleConnectionKey;
import org.mule.modules.workday.payrollinterface.process.ProcessCallback;
import org.mule.modules.workday.payrollinterface.process.ProcessInterceptor;
import org.mule.modules.workday.payrollinterface.processors.AbstractConnectedProcessor;
import org.mule.modules.workday.payrollinterface.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayrollInterfaceModuleManagedConnectionProcessInterceptor<T>
extends AbstractExpressionEvaluator
implements ProcessInterceptor<T, PayrollInterfaceModuleConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(PayrollInterfaceModuleManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<PayrollInterfaceModuleConnectionKey, PayrollInterfaceModuleConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, PayrollInterfaceModuleConnectionIdentifierAdapter> next;

    public PayrollInterfaceModuleManagedConnectionProcessInterceptor(ProcessInterceptor<T, PayrollInterfaceModuleConnectionIdentifierAdapter> next, ConnectionManager<PayrollInterfaceModuleConnectionKey, PayrollInterfaceModuleConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    @Override
    public T execute(ProcessCallback<T, PayrollInterfaceModuleConnectionIdentifierAdapter> processCallback, PayrollInterfaceModuleConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        String _transformedPayrollInterfaceUser;
        PayrollInterfaceModuleConnectionIdentifierAdapter connection = null;
        PayrollInterfaceModuleConnectionKey key = null;
        if (messageProcessor != null && messageProcessor instanceof AbstractConnectedProcessor && ((AbstractConnectedProcessor)messageProcessor).getPayrollInterfaceUser() != null) {
            _transformedPayrollInterfaceUser = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_payrollInterfaceUserType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getPayrollInterfaceUser());
            if (_transformedPayrollInterfaceUser == null) {
                throw new UnableToAcquireConnectionException("Parameter payrollInterfaceUser in method connect can't be null because is not @Optional");
            }
            String _transformedPayrollInterfacePassword = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_payrollInterfacePasswordType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getPayrollInterfacePassword());
            if (_transformedPayrollInterfacePassword == null) {
                throw new UnableToAcquireConnectionException("Parameter payrollInterfacePassword in method connect can't be null because is not @Optional");
            }
            String _transformedPayrollInterfaceEndpoint = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_payrollInterfaceEndpointType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getPayrollInterfaceEndpoint());
            if (_transformedPayrollInterfaceEndpoint == null) {
                throw new UnableToAcquireConnectionException("Parameter payrollInterfaceEndpoint in method connect can't be null because is not @Optional");
            }
            String _transformedPayrollInterfaceWsdlLocation = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_payrollInterfaceWsdlLocationType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getPayrollInterfaceWsdlLocation());
            key = new PayrollInterfaceModuleConnectionKey(_transformedPayrollInterfaceUser, _transformedPayrollInterfacePassword, _transformedPayrollInterfaceEndpoint, _transformedPayrollInterfaceWsdlLocation);
        } else {
            key = this.connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = this.connectionManager.acquireConnection(key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            _transformedPayrollInterfaceUser = this.next.execute(processCallback, connection, messageProcessor, event);
            return (T)_transformedPayrollInterfaceUser;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        if (connection == null) continue;
                        this.connectionManager.destroyConnection(key, connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection(key, connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    @Override
    public T execute(ProcessCallback<T, PayrollInterfaceModuleConnectionIdentifierAdapter> processCallback, PayrollInterfaceModuleConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

