/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.consumer;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.mule.module.ws.consumer.AbstractInputStreamStrategy;
import org.mule.util.Base64;
import org.mule.util.IOUtils;

public class URLRetrieverStrategy
extends AbstractInputStreamStrategy {
    private URL url;

    public URLRetrieverStrategy(String url) {
        this.url = IOUtils.getResourceAsUrl((String)url, this.getClass());
    }

    @Override
    public Definition retrieveWsdl() throws WSDLException {
        try {
            InputStream responseStream = null;
            Definition wsdlDefinition = null;
            URLConnection urlConnection = this.url.openConnection();
            if (this.url.getUserInfo() != null) {
                urlConnection.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])this.url.getUserInfo().getBytes()));
            }
            responseStream = urlConnection.getInputStream();
            wsdlDefinition = this.getWsdlDefinition(this.url.toString(), responseStream);
            responseStream.close();
            return wsdlDefinition;
        }
        catch (Exception e) {
            throw new WSDLException("Exception retrieving WSDL for URL: %s", this.url.toString(), (Throwable)e);
        }
    }
}

