/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.consumer;

import java.io.InputStream;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.mule.api.MuleContext;
import org.mule.module.http.api.requester.proxy.ProxyConfig;
import org.mule.module.http.internal.ParameterMap;
import org.mule.module.http.internal.domain.request.DefaultHttpRequest;
import org.mule.module.http.internal.domain.request.HttpRequest;
import org.mule.module.http.internal.domain.request.HttpRequestAuthentication;
import org.mule.module.http.internal.request.HttpAuthenticationType;
import org.mule.module.http.internal.request.HttpClientConfiguration;
import org.mule.module.http.internal.request.grizzly.GrizzlyHttpClient;
import org.mule.module.ws.consumer.AbstractInputStreamStrategy;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.transport.tcp.DefaultTcpClientSocketProperties;
import org.mule.transport.tcp.TcpClientSocketProperties;
import org.mule.util.concurrent.ThreadNameHelper;

public class HttpRequesterWsdlRetrieverStrategy
extends AbstractInputStreamStrategy {
    private static final int MINIMUM_KERNEL_MAX_POOL_SIZE = 1;
    private static final int MINIMUM_KERNEL_CORE_SIZE = 1;
    private static final int MINIMUM_WORKER_MAX_POOL_SIZE = 1;
    private static final int MINIMUM_WORKER_CORE_SIZE = 1;
    private static final int DEFAULT_CONNECTIONS = 1;
    private static final int DEFAULT_CONNECTION_IDLE_TIMEOUT = 30000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    private static final Boolean DEFAULT_FOLLOW_REDIRECTS = Boolean.TRUE;
    private static final Boolean DEFAULT_USE_PERSISTENT_CONNECTION = Boolean.FALSE;
    private static final String HTTP_METHOD_WSDL_RETRIEVAL = "GET";
    private static final String THREAD_NAME_PREFIX_PATTERN = "%shttp.requester.wsdl.%s";
    private static final String WSDL_RETRIEVER = "wsdl.retriever";
    private TcpClientSocketProperties socketProperties = new DefaultTcpClientSocketProperties();
    private final HttpRequestAuthentication basicAuthentication = new HttpRequestAuthentication(HttpAuthenticationType.BASIC);
    private TlsContextFactory tlsContextFactory = null;
    private ProxyConfig proxyConfig = null;
    private MuleContext context = null;
    private String url = null;

    public HttpRequesterWsdlRetrieverStrategy(String url, TlsContextFactory tlsContextFactory, ProxyConfig proxyConfig, MuleContext context) {
        this.tlsContextFactory = tlsContextFactory;
        this.proxyConfig = proxyConfig;
        this.context = context;
        this.url = url;
    }

    @Override
    public Definition retrieveWsdl() throws WSDLException {
        try {
            Definition wsdlDefinition = null;
            InputStream responseStream = null;
            String threadNamePrefix = String.format(THREAD_NAME_PREFIX_PATTERN, ThreadNameHelper.getPrefix((MuleContext)this.context), WSDL_RETRIEVER);
            HttpClientConfiguration configuration = new HttpClientConfiguration.Builder().setTlsContextFactory(this.tlsContextFactory).setProxyConfig(this.proxyConfig).setClientSocketProperties(this.socketProperties).setMaxConnections(1).setUsePersistentConnections(DEFAULT_USE_PERSISTENT_CONNECTION.booleanValue()).setConnectionIdleTimeout(30000).setThreadNamePrefix(threadNamePrefix).setOwnerName(WSDL_RETRIEVER).setMaxWorkerPoolSize(Integer.valueOf(1)).setWorkerCoreSize(Integer.valueOf(1)).setMaxKernelPoolSize(Integer.valueOf(1)).setKernelCoreSize(Integer.valueOf(1)).build();
            GrizzlyHttpClient httpClient = new GrizzlyHttpClient(configuration);
            httpClient.start();
            DefaultHttpRequest request = new DefaultHttpRequest(this.url.toString(), null, HTTP_METHOD_WSDL_RETRIEVAL, new ParameterMap(), new ParameterMap(), null);
            responseStream = httpClient.sendAndReceiveInputStream((HttpRequest)request, 60000, DEFAULT_FOLLOW_REDIRECTS.booleanValue(), this.basicAuthentication);
            wsdlDefinition = this.getWsdlDefinition(this.url, responseStream);
            httpClient.stop();
            responseStream.close();
            return wsdlDefinition;
        }
        catch (Exception e) {
            throw new WSDLException("Exception retrieving WSDL for URL: %s", this.url.toString(), (Throwable)e);
        }
    }
}

