/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.consumer;

import java.io.InputStream;
import javax.wsdl.WSDLException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.module.http.api.requester.proxy.ProxyConfig;
import org.mule.module.http.internal.ParameterMap;
import org.mule.module.http.internal.domain.request.DefaultHttpRequest;
import org.mule.module.http.internal.domain.request.HttpRequest;
import org.mule.module.http.internal.domain.request.HttpRequestAuthentication;
import org.mule.module.http.internal.request.HttpAuthenticationType;
import org.mule.module.http.internal.request.HttpClientConfiguration;
import org.mule.module.http.internal.request.grizzly.GrizzlyHttpClient;
import org.mule.module.ws.consumer.WsdlRetrieverStrategy;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.transport.ssl.api.TlsContextFactoryBuilder;
import org.mule.transport.tcp.DefaultTcpClientSocketProperties;
import org.mule.transport.tcp.TcpClientSocketProperties;
import org.mule.util.concurrent.ThreadNameHelper;

public class HttpRequesterWsdlRetrieverStrategy
implements WsdlRetrieverStrategy {
    private static final int MINIMUM_KERNEL_MAX_POOL_SIZE = 1;
    private static final int MINIMUM_KERNEL_CORE_SIZE = 1;
    private static final int MINIMUM_WORKER_MAX_POOL_SIZE = 1;
    private static final int MINIMUM_WORKER_CORE_SIZE = 1;
    private static final int DEFAULT_CONNECTIONS = 1;
    private static final int DEFAULT_SELECTOR_RUNNERS_COUNT = 1;
    private static final int DEFAULT_CONNECTION_IDLE_TIMEOUT = 30000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    private static final int DEFAULT_RESPONSE_BUFFER_SIZE = 10240;
    private static final Boolean DEFAULT_FOLLOW_REDIRECTS = Boolean.TRUE;
    private static final Boolean DEFAULT_USE_PERSISTENT_CONNECTION = Boolean.TRUE;
    private static final Boolean DEFAULT_STREAMING = Boolean.FALSE;
    private static final String HTTP_METHOD_WSDL_RETRIEVAL = "GET";
    private static final String THREAD_NAME_PREFIX_PATTERN = "%shttp.requester.wsdl.%s";
    private static final String WSDL_RETRIEVER = "wsdl.retriever";
    private TcpClientSocketProperties socketProperties = new DefaultTcpClientSocketProperties();
    private final HttpRequestAuthentication basicAuthentication = new HttpRequestAuthentication(HttpAuthenticationType.BASIC);
    private TlsContextFactory tlsContextFactory = null;
    private TlsContextFactory defaultTlsContextFactory = null;
    private ProxyConfig proxyConfig = null;
    private MuleContext context = null;

    public HttpRequesterWsdlRetrieverStrategy(TlsContextFactory tlsContextFactory, ProxyConfig proxyConfig, MuleContext context) {
        this.tlsContextFactory = tlsContextFactory;
        this.proxyConfig = proxyConfig;
        this.context = context;
        this.defaultTlsContextFactory = new TlsContextFactoryBuilder(context).buildDefault();
    }

    @Override
    public InputStream retrieveWsdlResource(String url) throws WSDLException {
        GrizzlyHttpClient client = null;
        try {
            InputStream responseStream;
            client = this.getHttpClient();
            DefaultHttpRequest request = new DefaultHttpRequest(url, null, HTTP_METHOD_WSDL_RETRIEVAL, new ParameterMap(), new ParameterMap(), null);
            InputStream inputStream = responseStream = this.getHttpClient().sendAndReceiveInputStream((HttpRequest)request, 60000, DEFAULT_FOLLOW_REDIRECTS.booleanValue(), this.basicAuthentication);
            return inputStream;
        }
        catch (Exception e) {
            throw new WSDLException("Exception retrieving WSDL for URL: %s", url.toString(), (Throwable)e);
        }
        finally {
            this.stop(client);
        }
    }

    private void stop(GrizzlyHttpClient client) {
        if (client != null) {
            client.stop();
        }
    }

    private GrizzlyHttpClient getHttpClient() throws MuleException {
        String threadNamePrefix = String.format(THREAD_NAME_PREFIX_PATTERN, ThreadNameHelper.getPrefix((MuleContext)this.context), WSDL_RETRIEVER);
        HttpClientConfiguration configuration = new HttpClientConfiguration.Builder().setTlsContextFactory(this.tlsContextFactory).setDefaultTlsContextFactory(this.defaultTlsContextFactory).setProxyConfig(this.proxyConfig).setClientSocketProperties(this.socketProperties).setMaxConnections(1).setUsePersistentConnections(DEFAULT_USE_PERSISTENT_CONNECTION.booleanValue()).setConnectionIdleTimeout(30000).setStreaming(DEFAULT_STREAMING.booleanValue()).setResponseBufferSize(10240).setThreadNamePrefix(threadNamePrefix).setOwnerName(WSDL_RETRIEVER).setMaxWorkerPoolSize(Integer.valueOf(1)).setWorkerCoreSize(Integer.valueOf(1)).setMaxKernelPoolSize(Integer.valueOf(1)).setKernelCoreSize(Integer.valueOf(1)).setSelectorRunnersCount(Integer.valueOf(1)).build();
        GrizzlyHttpClient httpClient = new GrizzlyHttpClient(configuration);
        httpClient.start();
        return httpClient;
    }
}

