/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.xpath;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.mule.api.MuleEvent;
import org.mule.api.MuleRuntimeException;
import org.mule.module.xml.i18n.XmlMessages;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.module.xml.xpath.XPathEvaluator;
import org.mule.module.xml.xpath.XPathNamespaceContext;
import org.mule.module.xml.xpath.XPathReturnType;
import org.mule.util.Preconditions;
import org.w3c.dom.Node;

public abstract class JaxpXPathEvaluator
implements XPathEvaluator,
XPathVariableResolver {
    private final XPathFactory xpathFactory;
    private final Map<String, String> prefixToNamespaceMap = new HashMap<String, String>();
    private final ThreadLocal<MuleEvent> evaluationEvent = new ThreadLocal();
    private final LoadingCache<String, XPathExpression> expressionCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, XPathExpression>(){

        public XPathExpression load(String key) throws Exception {
            return JaxpXPathEvaluator.this.compile(key);
        }
    });
    private NamespaceContext namespaceContext;

    public JaxpXPathEvaluator() {
        this.xpathFactory = this.createXPathFactory();
        this.namespaceContext = this.newNamespaceContext();
    }

    protected abstract XPathFactory createXPathFactory();

    @Override
    public String evaluate(String xpathExpression, Node input, MuleEvent event) {
        return (String)this.evaluate(xpathExpression, input, XPathReturnType.STRING, event);
    }

    @Override
    public Object evaluate(String xpathExpression, Node input, XPathReturnType returnType, MuleEvent event) {
        try {
            this.evaluationEvent.set(event);
            XPathExpression xpath = (XPathExpression)this.expressionCache.getUnchecked((Object)xpathExpression);
            Object object = xpath.evaluate(input, returnType.toQName());
            return object;
        }
        catch (XPathExpressionException e) {
            throw new MuleRuntimeException(XmlMessages.failedToProcessXPath(xpathExpression), (Throwable)e);
        }
        finally {
            this.evaluationEvent.remove();
        }
    }

    @Override
    public Object resolveVariable(QName variableName) {
        MuleEvent event = this.evaluationEvent.get();
        if (event != null) {
            return event.getFlowVariable(variableName.getLocalPart());
        }
        return null;
    }

    @Override
    public void registerNamespaces(Map<String, String> namespaces) {
        Preconditions.checkArgument((namespaces != null ? 1 : 0) != 0, (String)"cannot register null namespaces");
        this.prefixToNamespaceMap.putAll(namespaces);
        this.namespaceContext = this.newNamespaceContext();
        this.expressionCache.invalidateAll();
    }

    @Override
    public void registerNamespaces(NamespaceManager namespaceManager) {
        Preconditions.checkArgument((namespaceManager != null ? 1 : 0) != 0, (String)"cannot register a null namespace manager");
        this.registerNamespaces(namespaceManager.getNamespaces());
    }

    @Override
    public Map<String, String> getRegisteredNamespaces() {
        return ImmutableMap.copyOf(this.prefixToNamespaceMap);
    }

    protected XPath newXPath() {
        XPath xpath = this.xpathFactory.newXPath();
        xpath.setNamespaceContext(this.namespaceContext);
        xpath.setXPathVariableResolver(this);
        return xpath;
    }

    protected XPathExpression compile(String expression) throws XPathExpressionException {
        return this.newXPath().compile(expression);
    }

    protected NamespaceContext newNamespaceContext() {
        return new XPathNamespaceContext(this.prefixToNamespaceMap);
    }
}

