/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.util.List;
import org.dom4j.Node;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.xml.transformer.JXPathExtractor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class JXPathExtractorTestCase
extends AbstractMuleContextTestCase {
    protected static final String TEST_XML_MULTI_RESULTS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><node>value1</node><node>value2</node><node>value3</node></root>";
    protected static final String TEST_XML_MULTI_NESTED_RESULTS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><node><subnode1>val1</subnode1><subnode2>val2</subnode2></node><node><subnode1>val3</subnode1><subnode2>val4</subnode2></node></root>";
    protected static final String TEST_XML_SINGLE_RESULT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><node>value1</node></root>";

    @Test
    public void testSingeResult() throws Exception {
        JXPathExtractor extractor = (JXPathExtractor)this.createObject(JXPathExtractor.class);
        String expression = "/root/node";
        extractor.setExpression("/root/node");
        Assert.assertEquals((String)"Wrong expression returned.", (Object)"/root/node", (Object)extractor.getExpression());
        Object objResult = extractor.transform((Object)TEST_XML_SINGLE_RESULT);
        Assert.assertNotNull((Object)objResult);
        String result = (String)objResult;
        Assert.assertEquals((String)"Wrong value extracted.", (Object)"value1", (Object)result);
    }

    @Test
    public void testMultipleResults() throws Exception {
        JXPathExtractor extractor = (JXPathExtractor)this.createObject(JXPathExtractor.class);
        extractor.setExpression("/root/node");
        extractor.setSingleResult(false);
        Object objResult = extractor.transform((Object)TEST_XML_MULTI_RESULTS);
        Assert.assertNotNull((Object)objResult);
        List results = (List)objResult;
        Assert.assertEquals((String)"Wrong number of results returned.", (long)3L, (long)results.size());
        Assert.assertEquals((String)"Wrong value returned.", (Object)"value1", results.get(0));
        Assert.assertEquals((String)"Wrong value returned.", (Object)"value2", results.get(1));
        Assert.assertEquals((String)"Wrong value returned.", (Object)"value3", results.get(2));
    }

    @Test
    public void testMultipleResultsAsNode() throws Exception {
        JXPathExtractor extractor = (JXPathExtractor)this.createObject(JXPathExtractor.class);
        extractor.setExpression("/root/node");
        extractor.setSingleResult(false);
        extractor.setOutputType("NODE");
        Object objResult = extractor.transform((Object)TEST_XML_MULTI_RESULTS);
        Assert.assertNotNull((Object)objResult);
        List results = (List)objResult;
        Assert.assertEquals((String)"Wrong number of results returned.", (long)3L, (long)results.size());
        Assert.assertTrue((boolean)(results.get(0) instanceof Node));
    }

    @Test
    public void testMultipleResultsNested() throws Exception {
        JXPathExtractor extractor = (JXPathExtractor)this.createObject(JXPathExtractor.class);
        extractor.setExpression("/root/node[*]/*/text()");
        extractor.setSingleResult(false);
        Object objResult = extractor.transform((Object)TEST_XML_MULTI_NESTED_RESULTS);
        Assert.assertNotNull((Object)objResult);
        List results = (List)objResult;
        Assert.assertEquals((String)"Wrong number of results returned.", (long)4L, (long)results.size());
        Assert.assertEquals((String)"Wrong value returned.", (Object)"val1", results.get(0));
        Assert.assertEquals((String)"Wrong value returned.", (Object)"val2", results.get(1));
        Assert.assertEquals((String)"Wrong value returned.", (Object)"val3", results.get(2));
        Assert.assertEquals((String)"Wrong value returned.", (Object)"val4", results.get(3));
    }
}

