/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml.xstream;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.transformer.Transformer;
import org.mule.module.xml.transformer.ObjectToXml;
import org.mule.module.xml.transformer.XmlToObject;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.transformers.xml.AbstractXmlTransformerTestCase;

public class XmlObjectTransformersTestCase
extends AbstractXmlTransformerTestCase {
    private Apple testObject = null;
    private Map<String, Class<?>> aliases = new HashMap();

    public XmlObjectTransformersTestCase() {
        this.aliases.put("apple", Apple.class);
        this.testObject = new Apple();
        this.testObject.wash();
    }

    public Transformer getTransformer() throws Exception {
        ObjectToXml trans = (ObjectToXml)this.createObject(ObjectToXml.class);
        trans.setAliases(this.aliases);
        return trans;
    }

    public Transformer getRoundTripTransformer() throws Exception {
        XmlToObject trans = (XmlToObject)this.createObject(XmlToObject.class);
        trans.setAliases(this.aliases);
        return trans;
    }

    public Object getTestData() {
        return this.testObject;
    }

    public Object getResultData() {
        return "<apple>\n  <bitten>false</bitten>\n  <washed>true</washed>\n</apple>";
    }

    @Test
    public void testStreaming() throws Exception {
        XmlToObject transformer = (XmlToObject)this.createObject(XmlToObject.class);
        transformer.setAliases(this.aliases);
        String input = (String)this.getResultData();
        Assert.assertEquals((Object)this.testObject, (Object)transformer.transform((Object)new ByteArrayInputStream(input.getBytes())));
    }
}

