/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.DocumentResult;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.OutputHandler;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.xml.transformer.DelayedResult;
import org.mule.module.xml.util.XMLUtils;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.xmlsecurity.XMLSecureFactories;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public abstract class AbstractXmlTransformer
extends AbstractMessageTransformer
implements Initialisable {
    private String outputEncoding;
    private XMLInputFactory xmlInputFactory;
    private XMLOutputFactory xmlOutputFactory;
    private boolean useStaxSource = false;
    private boolean acceptExternalEntities = false;

    public AbstractXmlTransformer() {
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.create(Source.class));
        this.registerSourceType(DataTypeFactory.create(InputSource.class));
        this.registerSourceType(DataTypeFactory.create(Node.class));
        this.registerSourceType(DataTypeFactory.create(Document.class));
        this.registerSourceType(DataTypeFactory.create(org.w3c.dom.Document.class));
        this.registerSourceType(DataTypeFactory.create(Element.class));
        this.registerSourceType(DataTypeFactory.create(InputStream.class));
        this.registerSourceType(DataTypeFactory.create(OutputHandler.class));
        this.registerSourceType(DataTypeFactory.create(XMLStreamReader.class));
        this.registerSourceType(DataTypeFactory.create(DelayedResult.class));
        this.setReturnDataType(DataTypeFactory.create(byte[].class, (String)"text/xml"));
    }

    public final void initialise() throws InitialisationException {
        this.xmlInputFactory = XMLSecureFactories.createWithConfig((Boolean)this.acceptExternalEntities, null).getXMLInputFactory();
        this.useStaxSource = !this.acceptExternalEntities;
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
        this.doInitialise();
    }

    protected void doInitialise() throws InitialisationException {
    }

    protected static ResultHolder getResultHolder(Class<?> desiredClass) {
        if (desiredClass == null) {
            return null;
        }
        if (byte[].class.equals(desiredClass) || InputStream.class.isAssignableFrom(desiredClass)) {
            return new ResultHolder(){
                ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
                StreamResult result = new StreamResult((OutputStream)this.resultStream);

                @Override
                public Result getResult() {
                    return this.result;
                }

                @Override
                public Object getResultObject() {
                    return this.resultStream.toByteArray();
                }
            };
        }
        if (String.class.equals(desiredClass)) {
            return new ResultHolder(){
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(this.writer);

                @Override
                public Result getResult() {
                    return this.result;
                }

                @Override
                public Object getResultObject() {
                    return this.writer.getBuffer().toString();
                }
            };
        }
        if (org.w3c.dom.Document.class.isAssignableFrom(desiredClass)) {
            DOMResult result;
            try {
                DocumentBuilderFactory factory = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
                result = new DOMResult(factory.newDocumentBuilder().newDocument());
            }
            catch (Exception e) {
                throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Could not create result document"), (Throwable)e);
            }
            return new ResultHolder(){

                @Override
                public Result getResult() {
                    return result;
                }

                @Override
                public Object getResultObject() {
                    return result.getNode();
                }
            };
        }
        if (DocumentResult.class.isAssignableFrom(desiredClass)) {
            return new ResultHolder(){
                DocumentResult result = new DocumentResult();

                @Override
                public Result getResult() {
                    return this.result;
                }

                @Override
                public Object getResultObject() {
                    return this.result;
                }
            };
        }
        if (Document.class.isAssignableFrom(desiredClass)) {
            return new ResultHolder(){
                DocumentResult result = new DocumentResult();

                @Override
                public Result getResult() {
                    return this.result;
                }

                @Override
                public Object getResultObject() {
                    return this.result.getDocument();
                }
            };
        }
        return null;
    }

    @Deprecated
    protected String convertToText(Object obj) throws Exception {
        return this.convertToText(obj, null);
    }

    protected String convertToText(Object obj, String outputEncoding) throws Exception {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Node) {
            return ((Node)obj).asXML();
        }
        Source src = XMLUtils.toXmlSource(this.xmlInputFactory, this.useStaxSource, obj);
        if (src == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer idTransformer = XMLSecureFactories.createDefault().getTransformerFactory().newTransformer();
        if (outputEncoding != null) {
            idTransformer.setOutputProperty("encoding", outputEncoding);
        }
        idTransformer.transform(src, result);
        return writer.getBuffer().toString();
    }

    protected String convertToBytes(Object obj, String outputEncoding) throws Exception {
        Source src = XMLUtils.toXmlSource(this.xmlInputFactory, this.useStaxSource, obj);
        if (src == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer idTransformer = XMLUtils.getTransformer();
        idTransformer.setOutputProperty("encoding", outputEncoding);
        idTransformer.transform(src, result);
        return writer.getBuffer().toString();
    }

    protected void writeToStream(Object obj, String outputEncoding, OutputStream output) throws Exception {
        Source src = XMLUtils.toXmlSource(this.xmlInputFactory, this.useStaxSource, obj);
        if (src == null) {
            return;
        }
        StreamResult result = new StreamResult(output);
        Transformer idTransformer = XMLUtils.getTransformer();
        idTransformer.setOutputProperty("encoding", outputEncoding);
        idTransformer.transform(src, result);
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public boolean isUseStaxSource() {
        return this.useStaxSource;
    }

    public void setUseStaxSource(boolean useStaxSource) {
        this.useStaxSource = useStaxSource;
    }

    public XMLInputFactory getXMLInputFactory() {
        return this.xmlInputFactory;
    }

    public void setXMLInputFactory(XMLInputFactory xmlInputFactory) {
        this.xmlInputFactory = xmlInputFactory;
    }

    public XMLOutputFactory getXMLOutputFactory() {
        return this.xmlOutputFactory;
    }

    public void setXMLOutputFactory(XMLOutputFactory xmlOutputFactory) {
        this.xmlOutputFactory = xmlOutputFactory;
    }

    public void setAcceptExternalEntities(boolean acceptExternalEntities) {
        this.acceptExternalEntities = acceptExternalEntities;
    }

    public boolean getAcceptExternalEntities() {
        return this.acceptExternalEntities;
    }

    protected static interface ResultHolder {
        public Result getResult();

        public Object getResultObject();
    }
}

