/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers;

import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.xml.util.XMLTestUtils;
import org.mule.tck.junit4.FunctionalTestCase;

public class XsltWithXmlParamsTestCase
extends FunctionalTestCase {
    private static final String EXPECTED = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><result><body><just>testing</just></body><fromParam>value element</fromParam></result>";

    protected String getConfigFile() {
        return "xslt-with-xml-param-config.xml";
    }

    @Test
    public void xmlSourceParam() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("xmlSourceParam");
        MuleEvent event = flow.process(this.buildEvent(XMLTestUtils.toSource("simple.xml"), XMLTestUtils.toSource("test.xml")));
        this.assertExpected(event);
    }

    @Test
    public void xmlStringParam() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("xmlStringParam");
        MuleEvent event = flow.process(this.buildEvent(XMLTestUtils.toString("simple.xml"), XMLTestUtils.toString("test.xml")));
        this.assertExpected(event);
    }

    private MuleEvent buildEvent(Object payload, Object param) throws Exception {
        MuleEvent event = XsltWithXmlParamsTestCase.getTestEvent((Object)payload);
        event.setFlowVariable("xml", param);
        return event;
    }

    private void assertExpected(MuleEvent event) throws Exception {
        Assert.assertThat((Object)XMLUnit.compareXML((String)event.getMessage().getPayload().toString(), (String)EXPECTED).similar(), (Matcher)CoreMatchers.is((Object)true));
    }
}

