/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.jaxb;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.jaxb.model.Item;
import org.mule.module.xml.util.XMLUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.types.DataTypeFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JaxbAutoTransformerTestCase
extends AbstractMuleContextTestCase {
    public static final String ITEM_XML = "<item><code>1234</code><description>Vacuum Cleaner</description><in-stock>true</in-stock></item>";

    @Test
    public void testCustomTransform() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)ITEM_XML, muleContext);
        Item item = (Item)message.getPayload(DataTypeFactory.create(Item.class));
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)"1234", (Object)item.getCode());
        Assert.assertEquals((Object)"Vacuum Cleaner", (Object)item.getDescription());
        Assert.assertTrue((boolean)item.isInStock());
        Document doc = (Document)message.getPayload(DataTypeFactory.create(Document.class));
        Assert.assertNotNull((Object)doc);
        Assert.assertEquals((Object)"1234", (Object)XMLUtils.selectValue((String)"/item/code", (Node)doc));
        Assert.assertEquals((Object)"Vacuum Cleaner", (Object)XMLUtils.selectValue((String)"/item/description", (Node)doc));
        Assert.assertEquals((Object)"true", (Object)XMLUtils.selectValue((String)"/item/in-stock", (Node)doc));
    }
}

