/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml.xslt;

import java.io.ByteArrayInputStream;
import junit.framework.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.util.IOUtils;

public class XsltTransformerXXETestCase
extends FunctionalTestCase {
    @Rule
    public final SystemProperty expandEntities = new SystemProperty("mule.xml.expandInternalEntities", "true");

    protected String getConfigFile() {
        return "xslt-xxe-config.xml";
    }

    @Test(expected=TransformerMessagingException.class)
    public void xxeAsStream() throws Exception {
        String input = this.makeInput();
        this.runFlow("safeXxe", new ByteArrayInputStream(input.getBytes())).getMessage().getPayload();
    }

    @Test(expected=TransformerMessagingException.class)
    public void xxeAsString() throws Exception {
        String input = this.makeInput();
        this.runFlow("safeXxe", input).getMessage().getPayload();
    }

    @Test(expected=TransformerMessagingException.class)
    public void xxeAsByteArray() throws Exception {
        String input = this.makeInput();
        this.runFlow("safeXxe", input.getBytes()).getMessage().getPayload();
    }

    @Test
    public void unsafeXxeAsStream() throws Exception {
        String input = this.makeInput();
        this.assertUnsafe(new ByteArrayInputStream(input.getBytes()));
    }

    @Test
    public void unsafeXxeAsString() throws Exception {
        String input = this.makeInput();
        this.assertUnsafe(input);
    }

    @Test
    public void unsafeXxeAsByteArray() throws Exception {
        String input = this.makeInput();
        this.assertUnsafe(input.getBytes());
    }

    private void assertUnsafe(Object payload) throws Exception {
        String output = (String)this.runFlow("unsafeXxe", payload).getMessage().getPayload();
        Assert.assertTrue((boolean)output.contains("secret"));
    }

    private String makeInput() {
        return String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE spi_doc_type[ <!ENTITY spi_entity_ref SYSTEM 'file:%s'>]>\n<root>\n<elem>&spi_entity_ref;</elem>\n<something/>\n</root>", IOUtils.getResourceAsUrl((String)"xxe-passwd.txt", ((Object)((Object)this)).getClass()).getPath());
    }
}

