/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.module.xml.stax.StaxSource;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.xml.sax.SAXParseException;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class StaxSourceTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private XMLStreamReader mockReader;
    @Mock
    private XMLStreamException mockException;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.mockReader.getEventType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockReader.next()).thenThrow(new Throwable[]{this.mockException});
    }

    @Test
    public void parseExceptionWithoutLocation() throws Exception {
        this.parseWithException(-1, -1);
    }

    @Test
    public void parseExceptionWithLocation() throws Exception {
        Location location = (Location)Mockito.mock(Location.class);
        int columNumber = 10;
        int lineNumber = 20;
        Mockito.when((Object)location.getColumnNumber()).thenReturn((Object)10);
        Mockito.when((Object)location.getLineNumber()).thenReturn((Object)20);
        Mockito.when((Object)this.mockException.getLocation()).thenReturn((Object)location);
        this.parseWithException(10, 20);
    }

    private void parseWithException(int expectedColumnNumber, int expectedLineNumber) throws Exception {
        StaxSource staxSource = new StaxSource(this.mockReader);
        try {
            staxSource.getXMLReader().parse("");
            Assert.fail((String)"was expecting a exception");
        }
        catch (SAXParseException e) {
            Assert.assertThat((Object)e.getColumnNumber(), (Matcher)CoreMatchers.is((Object)expectedColumnNumber));
            Assert.assertThat((Object)e.getLineNumber(), (Matcher)CoreMatchers.is((Object)expectedLineNumber));
        }
    }
}

