package org.mule.soapkit.soap.server.interceptor;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * Replace C0 control characters (except CR(\u000D), LF(\u000A) and HT (\u0009))
 */
public class CtrlToNCRInputStream extends FilterInputStream {

  private final byte[] replacementBytes = {'&', '#', '0', '0', ';'};
  private int replacementIndex = 100;

  public CtrlToNCRInputStream(InputStream in) {
    super(in);
  }

  @Override
  public int read() throws IOException {
    if (replacementIndex < 5) {
      return replacementBytes[replacementIndex++];
    } else {
      int b = super.read();
      if (isNonHTLFCR_C0ControlCharacter(b)) {
        replacementIndex = 0;
        byte[] cnrBytes = padInteger(b).getBytes();
        replacementBytes[2] = cnrBytes[0];
        replacementBytes[3] = cnrBytes[1];
        return replacementBytes[replacementIndex++];
      } else {
        return b;
      }
    }
  }

  /**
   * Convert integer {@code 2} to string {@code "02"}
   * @param number
   * @return
   */
  public static String padInteger(int number) {
    String numberStr = String.valueOf(number);
    if (numberStr.length() == 1) {
      return "0" + numberStr;
    } else {
      return numberStr;
    }
  }

  @Override
  public int read(byte[] b, int off, int len) throws IOException {
    int totalRead = 0;
    while (totalRead < len) {
      int readByte = read();
      if (readByte == -1) {
        return totalRead == 0 ? -1 : totalRead;
      }
      b[off + totalRead] = (byte) readByte;
      totalRead++;
    }
    return totalRead;
  }

  /**
   * Identify if a character is a C0 character but not one of HT (Horizontal Tabulation) U+0009, LF (Line Feed) U+000A, and CR (Carriage Return) U+000D.
   * @param c
   * @return
   */
  private boolean isNonHTLFCR_C0ControlCharacter(int c) {
    return (c > 0 && c < 32 && c != '\r' && c != '\n' && c != '\t');
  }
}
