package org.mule.soapkit.soap.server.interceptor;

import com.ctc.wstx.api.InvalidCharHandler;

import java.io.IOException;

/**
 * Custom invalid character handler. NCR (Numeric character reference) appear as invalid characters in writer.
 * They are converted to the corresponding control character.
 *
 */
public class NCRToControlCharHandler implements InvalidCharHandler {

  @Override
  public char convertInvalidChar(int invalidChar) throws IOException {
    if (invalidChar > 0 && invalidChar < 32) {
      return (char) invalidChar;
    }
    return '#';
  }
}
