/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap.server.interceptor;

import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.Phase;
import org.mule.runtime.soap.api.exception.BadRequestException;
import javax.xml.namespace.QName;
import java.util.List;
import java.util.Map;

import org.mule.soapkit.soap.message.SoapResponse;
import org.mule.soapkit.soap.util.Cast;

import static java.util.Collections.emptyList;
import static java.util.stream.Collectors.toList;
import static org.mule.soapkit.soap.SoapConstants.SERVER_RESPONSE_KEY;
import static org.mule.soapkit.soap.util.XmlTransformationUtils.stringToDomElement;

public class OutputSoapHeadersInterceptor extends AbstractSoapInterceptor {

  public OutputSoapHeadersInterceptor() {
    super(Phase.PRE_PROTOCOL);
  }

  @Override
  public void handleMessage(SoapMessage message) throws Fault {
    // Copy Headers to Cxf
    final SoapResponse response = Cast.cast(message.getExchange().get(SERVER_RESPONSE_KEY));

    if (response == null)
      return;

    message.put(Header.HEADER_LIST, transformToCxfHeaders(response.getSoapHeaders()));
  }

  // Same code in SoapCxfClient
  private List<SoapHeader> transformToCxfHeaders(Map<String, String> headers) {
    if (headers == null) {
      return emptyList();
    }
    return headers.entrySet().stream()
        .map(header -> {
          try {
            return new SoapHeader(new QName(null, header.getKey()), stringToDomElement(header.getValue()));
          } catch (Exception e) {
            throw new BadRequestException("Cannot parse input header [" + header.getKey() + "]", e);
          }
        })
        .collect(toList());
  }
}
