/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.server.interceptor;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

public class SeekBopInterceptor
extends AbstractInDatabindingInterceptor {
    public SeekBopInterceptor() {
        super("unmarshal");
    }

    public void handleMessage(Message message) throws Fault {
        DepthXMLStreamReader xmlReader = this.getXMLStreamReader(message);
        Exchange exchange = message.getExchange();
        BindingOperationInfo bop = exchange.getBindingOperationInfo();
        boolean client = this.isRequestor(message);
        if (bop != null && !StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
            return;
        }
        if ((bop = this.getBindingOperationInfo(xmlReader, exchange, bop, client)) != null) {
            exchange.put(BindingOperationInfo.class, (Object)bop);
            exchange.put(OperationInfo.class, (Object)bop.getOperationInfo());
        }
    }

    private BindingOperationInfo getBindingOperationInfo(DepthXMLStreamReader xmlReader, Exchange exchange, BindingOperationInfo bop, boolean client) {
        if (bop != null && bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        if (bop == null) {
            QName startQName = xmlReader == null ? new QName("http://cxf.apache.org/jaxws/provider", "invoke") : xmlReader.getName();
            bop = this.getBindingOperationInfo(exchange, startQName, client);
        }
        return bop;
    }

    protected BindingOperationInfo getBindingOperationInfo(Exchange exchange, QName name, boolean client) {
        BindingOperationInfo bop;
        String local = name.getLocalPart();
        if (client && local.endsWith("Response")) {
            local = local.substring(0, local.length() - 8);
        }
        if ((bop = SeekBopInterceptor.getOperation(exchange, local)) != null) {
            exchange.put(BindingOperationInfo.class, (Object)bop);
            exchange.put(OperationInfo.class, (Object)bop.getOperationInfo());
        }
        return bop;
    }

    private static BindingOperationInfo getOperation(Exchange exchange, String opName) {
        Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
        if (ep == null) {
            return null;
        }
        BindingInfo service = ep.getEndpointInfo().getBinding();
        for (BindingOperationInfo bopInfo : service.getOperations()) {
            MessageInfo messageInfo = bopInfo.getInput().getMessageInfo();
            List messageParts = messageInfo.getMessageParts();
            if (messageInfo.getName().getLocalPart().equals(opName)) {
                return bopInfo;
            }
            for (MessagePartInfo info : messageParts) {
                QName elementQName = info.getElementQName();
                String requestName = elementQName != null ? elementQName.getLocalPart() : "";
                if (!requestName.equals(opName)) continue;
                return bopInfo;
            }
        }
        return null;
    }
}

