/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap.message;

import java.io.InputStream;
import java.util.Map;
import org.mule.runtime.api.metadata.TypedValue;

import org.mule.soap.api.message.SoapAttachment;

public abstract class AbstractSoapResponse implements SoapResponse {

  private final Map<String, String> transportHeaders;
  private final Map<String, String> transportAdditionalData;
  private final Map<String, TypedValue<?>> variables;

  protected AbstractSoapResponse(Map<String, String> transportHeaders,
                                 Map<String, String> transportAdditionalData,
                                 Map<String, TypedValue<?>> variables) {
    this.transportHeaders = transportHeaders;
    this.transportAdditionalData = transportAdditionalData;
    this.variables = variables;
  }

  @Override
  public Map<String, TypedValue<?>> getVariables() {
    return variables;
  }

  @Override
  public Map<String, String> getTransportAdditionalData() {
    return transportAdditionalData;
  }

  @Override
  public Map<String, String> getTransportHeaders() {
    return transportHeaders;
  }

  @Override
  public abstract Map<String, String> getSoapHeaders();

  @Override
  public abstract InputStream getContent();

  @Override
  public abstract Map<String, SoapAttachment> getAttachments();

  @Override
  public abstract String getContentType();
}
