/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap.message;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.soap.api.message.SoapAttachment;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

import static java.util.Collections.emptyMap;
import static org.mule.runtime.api.metadata.MediaType.ANY;

/**
 * Empty {@link SoapResponse} implementation.
 *
 * @since 1.0
 */
public final class EmptySoapResponse extends AbstractSoapResponse {

  /**
   * @deprecated Please use {@link EmptySoapResponse#EmptySoapResponse(Map)} instead. Defaulting to an empty set of
   *             variables will break the execution context.
   */
  @Deprecated
  public EmptySoapResponse() {
    super(emptyMap(), emptyMap(), emptyMap());
  }

  public EmptySoapResponse(Map<String, TypedValue<?>> variables) {
    super(emptyMap(), emptyMap(), variables);
  }

  public EmptySoapResponse(Map<String, String> transportHeaders,
                           Map<String, String> transportAdditionalData,
                           Map<String, TypedValue<?>> variables) {
    super(transportHeaders, transportAdditionalData, variables);
  }

  @Override
  public InputStream getContent() {
    return new ByteArrayInputStream(new byte[0]);
  }

  @Override
  public Map<String, String> getSoapHeaders() {
    return emptyMap();
  }

  @Override
  public Map<String, SoapAttachment> getAttachments() {
    return emptyMap();
  }

  @Override
  public String getContentType() {
    return ANY.toString();
  }
}
