/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap.server.interceptor;

import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public class AttachmentOutputInterceptor extends AttachmentOutInterceptor {

  public AttachmentOutputInterceptor() {
    addBefore(StaxOutInterceptor.class.getName());
  }

  @Override
  public void handleMessage(final Message message) {

    // Mtom Flag is seted in inMessage during SoapCxfServer sendThroughCxf method
    // AttachmentOutInterceptor needs it in outMessage. I couldn't find a better way to do that
    final boolean isMtom = MessageUtils.getContextualBoolean(message.getExchange().getInMessage(), Message.MTOM_ENABLED, false);

    message.put(Message.MTOM_ENABLED, isMtom ? Boolean.TRUE : Boolean.FALSE);

    super.handleMessage(message);
  }
}
