/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap.server.interceptor;

import java.util.Map;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.Phase;

public class CustomNamespacesInterceptor extends AbstractSoapInterceptor {

  private Map<String, String> namespacePrefixes;

  public CustomNamespacesInterceptor(Map<String, String> namespacePrefixes) {
    super(Phase.PRE_PROTOCOL);
    this.namespacePrefixes = namespacePrefixes;
  }

  @Override
  public void handleMessage(SoapMessage message) throws Fault {
    if (namespacePrefixes != null) {
      message.put("soap.env.ns.map", namespacePrefixes);
      message.put("disable.outputstream.optimization", true);
    }
  }
}
