/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap.server.interceptor;

import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;

public class RemoveCheckClosingTagsInterceptor extends AbstractPhaseInterceptor<Message> {

  public RemoveCheckClosingTagsInterceptor() {
    super(Phase.PRE_LOGICAL);
  }

  @Override
  public void handleMessage(Message message) throws Fault {
    for (Interceptor<? extends Message> inInterceptor : message.getInterceptorChain()) {
      if (inInterceptor.getClass().equals(ReadHeadersInterceptor.CheckClosingTagsInterceptor.class)) {
        message.getInterceptorChain().remove(inInterceptor);
        break;
      }
    }
  }
}
