package org.mule.soapkit.soap.server.interceptor;

import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;

public class WriteXmlDeclarationOutInterceptor extends AbstractPhaseInterceptor<SoapMessage> {

  private boolean responseXMLDeclarationEnabled;

  public WriteXmlDeclarationOutInterceptor() {
    super(Phase.PRE_STREAM);
    addBefore("org.apache.cxf.interceptor.StaxOutInterceptor");
  }

  public WriteXmlDeclarationOutInterceptor(Boolean responseXMLDeclarationEnabled) {
    this();
    this.responseXMLDeclarationEnabled = responseXMLDeclarationEnabled;
  }

  @Override
  public void handleMessage(SoapMessage message) throws Fault {
    message.put("org.apache.cxf.stax.force-start-document", responseXMLDeclarationEnabled);
  }
}
