/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap.server.transport;

import org.apache.cxf.Bus;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.local.LocalDestination;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.mule.soapkit.soap.server.support.DelegatingOutputStream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public class ProxyDestinationFactory extends LocalDestination {

  private static final Logger LOGGER = Logger.getLogger(ProxyDestinationFactory.class.getName());
  private ProxyTransport transport;

  public ProxyDestinationFactory(ProxyTransport transport,
                                 EndpointReferenceType ref,
                                 EndpointInfo ei,
                                 Bus bus) {
    super(transport, ref, ei, bus);
    this.transport = transport;
  }

  @Override
  protected Conduit getInbuiltBackChannel(Message inMessage) {
    return new ResponseConduit(null);
  }

  @Override
  protected Logger getLogger() {
    return LOGGER;
  }

  @Override
  public void shutdown() {
    transport.remove(this);

    super.shutdown();
  }

  public static class ResponseConduit extends AbstractConduit {

    private static final Logger LOGGER = Logger.getLogger(ResponseConduit.class.getName());

    public ResponseConduit(EndpointReferenceType arg0) {
      super(arg0);
    }

    public void prepare(Message message) throws IOException {
      // set an outputstream which will be used for things like attachment headers.
      // we'll stream the body later on down the line via the OutputHandler in CxfServiceComponent
      DelegatingOutputStream stream = new DelegatingOutputStream(new ByteArrayOutputStream());
      message.setContent(OutputStream.class, stream);
      message.setContent(DelegatingOutputStream.class, stream);
    }

    @Override
    public void close(Message message) throws IOException {
      message.getContent(OutputStream.class).close();
    }

    @Override
    protected Logger getLogger() {
      return LOGGER;
    }

  }
}

