/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap.server.transport;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.local.LocalDestination;
import org.apache.cxf.transport.local.LocalTransportFactory;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ProxyTransport extends LocalTransportFactory {

  private final ConcurrentMap<String, LocalDestination> destinations = new ConcurrentHashMap<>();

  public ProxyTransport() {
    setUriPrefixes(new HashSet<>(Arrays.asList("http", "https", "local")));
  }

  @Override
  public LocalDestination getDestination(EndpointInfo ei, EndpointReferenceType reference, Bus bus) {
    String uri = reference.getAddress().getValue();
    int idx = uri.indexOf('?');
    if (idx != -1) {
      uri = uri.substring(0, idx);
    }

    synchronized (this) {
      return destinations.computeIfAbsent(uri, k -> createProxyDestination(ei, reference, bus));
    }
  }

  void remove(ProxyDestinationFactory destination) {
    destinations.remove(destination.getAddress().getAddress().getValue());
  }

  private LocalDestination createProxyDestination(EndpointInfo ei, EndpointReferenceType reference, Bus bus) {
    return new ProxyDestinationFactory(this, reference, ei, bus);
  }

}
