/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap;

import org.mule.soapkit.soap.api.server.SoapService;
import org.mule.soapkit.soap.api.server.SoapServerFactory;
import org.mule.soapkit.soap.server.SoapCxfServerFactory;

/**
 * Default Mule {@link SoapService} implementation.
 *
 * @since 1.1
 */
public class SoapServiceImplementation implements SoapService {

  @Override
  public String getName() {
    return "SOAP Service";
  }

  public SoapServerFactory getServerFactory() {
    return new SoapCxfServerFactory();
  }
}
