/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap.api.server;

import java.util.Map;
import org.mule.soap.api.SoapVersion;
import org.mule.soapkit.soap.api.param.ValidationLevel;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;

import java.net.URL;

/**
 * Represents a Soap Server Configuration with all the required attributes for setting a connection with the Web Service.
 *
 * @since 4.1
 */
public final class SoapServerConfiguration {

  private final WsdlModel wsdlModel;
  private final URL wsdlLocation;
  private final String namespace;
  private final ServiceModel serviceModel;
  private final PortModel portModel;
  private final SoapVersion version;
  private final boolean mtomEnabled;
  private final boolean validationEnabled;

  private final boolean responseXMLDeclarationEnabled;
  private final ValidationLevel validationLevel;
  private final boolean payloadBody;
  private final Map<String, String> namespacePrefixes;

  SoapServerConfiguration(WsdlModel wsdlModel, URL wsdlLocation,
                          String namespace, ServiceModel serviceModel, PortModel portModel,
                          SoapVersion version, boolean mtomEnabled,
                          boolean validationEnabled,
                          boolean payloadBody, Map<String, String> namespacePrefixes, boolean responseXMLDeclarationEnabled) {

    this.wsdlModel = wsdlModel;
    this.wsdlLocation = wsdlLocation;
    this.namespace = namespace;
    this.serviceModel = serviceModel;
    this.portModel = portModel;
    this.version = version;
    this.mtomEnabled = mtomEnabled;
    this.validationEnabled = validationEnabled;
    this.responseXMLDeclarationEnabled = responseXMLDeclarationEnabled;
    this.payloadBody = payloadBody;
    this.namespacePrefixes = namespacePrefixes;
    this.validationLevel = ValidationLevel.WARN;
  }

  SoapServerConfiguration(WsdlModel wsdlModel, URL wsdlLocation,
                          String namespace, ServiceModel serviceModel, PortModel portModel,
                          SoapVersion version, boolean mtomEnabled,
                          boolean validationEnabled,
                          boolean payloadBody, Map<String, String> namespacePrefixes,
                          ValidationLevel validationLevel, boolean responseXMLDeclarationEnabled) {
    this.wsdlModel = wsdlModel;
    this.wsdlLocation = wsdlLocation;
    this.namespace = namespace;
    this.serviceModel = serviceModel;
    this.portModel = portModel;
    this.version = version;
    this.mtomEnabled = mtomEnabled;
    this.validationEnabled = validationEnabled;
    this.responseXMLDeclarationEnabled = responseXMLDeclarationEnabled;
    this.payloadBody = payloadBody;
    this.namespacePrefixes = namespacePrefixes;
    this.validationLevel = validationLevel;
  }

  public static SoapServerConfigurationBuilder builder() {
    return new SoapServerConfigurationBuilder();
  }

  public URL getWsdlLocation() {
    return wsdlLocation;
  }

  public SoapVersion getVersion() {
    return version;
  }

  public boolean isValidationEnabled() {
    return validationEnabled;
  }

  public boolean isPayloadBody() {
    return payloadBody;
  }

  public String getNamespace() {
    return namespace;
  }

  public String getService() {
    return serviceModel.getName();
  }

  public String getPort() {
    return portModel.getName();
  }

  public PortModel getPortModel() {
    return portModel;
  }

  public boolean isMtomEnabled() {
    return this.mtomEnabled;
  }

  public boolean isResponseXMLDeclarationEnabled() {
    return this.responseXMLDeclarationEnabled;
  }

  public WsdlModel getWsdlModel() {
    return wsdlModel;
  }

  public Map<String, String> getNamespacePrefixes() {
    return namespacePrefixes;
  }

  public ValidationLevel getValidationErrorLevel() {
    return validationLevel;
  }

}
