/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap.api.server;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soapkit.soap.message.SoapResponse;

import java.util.Map;
import java.util.concurrent.ExecutionException;

import static java.util.Collections.emptyMap;

/**
 * Coordinates the interaction between mule-soapkit-cxf and its consumer
 */
public interface SoapServerHandler {

  /**
   * Handles a given request
   * @param request the request to handle
   * @return the corresponding response for that request
   * @throws ExecutionException an asynchronous operation failed to execute
   */
  SoapResponse handle(SoapRequest request) throws ExecutionException;

  /**
   * @return the variable mappings for the event that created this handler
   */
  default Map<String, TypedValue<?>> getVariables() {
    return emptyMap();
  }
}
