/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap.server.interceptor;

import com.google.common.collect.ImmutableMap;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.api.client.BadResponseException;
import org.mule.soapkit.soap.message.SoapResponse;
import org.mule.soapkit.soap.util.Cast;

import java.io.IOException;
import java.util.Map;

import static java.lang.String.format;
import static org.apache.cxf.phase.Phase.SETUP;
import static org.mule.soapkit.soap.SoapConstants.SERVER_RESPONSE_KEY;
import static org.mule.soapkit.soap.util.DataHandlerUtils.toDataHandler;

public class CopyAttachmentOutInterceptor extends AbstractPhaseInterceptor<Message> {

  public CopyAttachmentOutInterceptor() {
    super(SETUP);
  }

  @Override
  public void handleMessage(Message message) throws Fault {
    final SoapResponse response = Cast.cast(message.getExchange().get(SERVER_RESPONSE_KEY));

    if (response == null)
      return;

    final Map<String, SoapAttachment> attachments = response.getAttachments();
    message.setAttachments(transformToCxfAttachments(attachments).values());
  }

  // Copied from SoapCxfClient.
  private Map<String, Attachment> transformToCxfAttachments(final Map<String, SoapAttachment> attachments) {
    ImmutableMap.Builder<String, Attachment> builder = ImmutableMap.builder();
    attachments.forEach((name, value) -> {
      try {
        builder.put(name,
                    new AttachmentImpl(name, toDataHandler(name, value.getContent(), MediaType.parse(value.getContentType()))));
      } catch (IOException e) {
        throw new BadResponseException(format("Error while preparing attachment [%s] for download", name), e);
      }
    });
    return builder.build();
  }

}


