/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.server.interceptor;

import com.google.common.collect.ImmutableMap;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soapkit.soap.util.XmlTransformationException;
import org.mule.soapkit.soap.util.XmlTransformationUtils;
import org.w3c.dom.Node;

public class InputSoapHeadersInterceptor
extends AbstractSoapInterceptor {
    public InputSoapHeadersInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        ImmutableMap.Builder headers = ImmutableMap.builder();
        message.getHeaders().stream().filter(header -> header instanceof SoapHeader).map(h -> (SoapHeader)h).forEach(header -> headers.put((Object)header.getName().getLocalPart(), (Object)this.getHeaderInputStream((SoapHeader)header)));
        message.getExchange().put((Object)"mule.soap.headers", (Object)headers.build());
    }

    private String getHeaderInputStream(SoapHeader header) {
        try {
            return XmlTransformationUtils.nodeToString((Node)header.getObject());
        }
        catch (XmlTransformationException e) {
            throw new BadRequestException(String.format("Cannot parse content of SOAP header %s in the response", header.getName().getLocalPart()), e.getCause());
        }
    }
}

