/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.internal.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.wsdl.parser.WsdlParser;
import org.mule.wsdl.parser.model.WsdlModel;

public class WsdlUtils {
    private static final String ROOT_API = "api/";

    public static WsdlModel getWsdlModel(String wsdlLocation) throws ConnectionException {
        if (StringUtils.isBlank((String)wsdlLocation)) {
            throw new ConnectionException("Parameter wsdlLocation is missing in config");
        }
        String wsdlUrl = WsdlUtils.getWsdlLocationUrl(wsdlLocation).toString();
        try {
            return WsdlParser.Companion.parse(wsdlUrl, "UTF-8");
        }
        catch (Exception e) {
            throw new ConnectionException(String.format("Error parsing WSDL file '%s'", wsdlUrl), (Throwable)e);
        }
    }

    public static URL getWsdlLocationUrl(String wsdlLocation) throws ConnectionException {
        URL resource = WsdlUtils.tryGetURL(wsdlLocation);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (resource == null) {
            resource = classLoader.getResource(wsdlLocation);
        }
        if (resource == null) {
            resource = classLoader.getResource(ROOT_API + wsdlLocation);
        }
        if (resource == null) {
            throw new ConnectionException(String.format("Cannot create URL for wsdlLocation '%s' in config [%s]", wsdlLocation, classLoader.getClass().getName()));
        }
        return resource;
    }

    private static URL tryGetURL(String wsdlLocation) {
        try {
            return new URL(wsdlLocation);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

