/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.extension.validation.api.ValidationException;
import org.mule.extension.validation.api.ValidationExtension;
import org.mule.extension.validation.api.ValidationOptions;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.api.Validator;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ValidationSupport {
    protected static final String ERROR_GROUP = "Error options";
    protected static final Logger LOGGER = LoggerFactory.getLogger(ValidationSupport.class);

    ValidationSupport() {
    }

    protected void validateWith(Validator validator, ValidationContext validationContext) throws Exception {
        ValidationResult result = validator.validate();
        if (result.isError()) {
            result = this.evaluateCustomMessage(result, validationContext);
            throw new ValidationException(result, result.getErrorType());
        }
        this.logSuccessfulValidation(validator);
    }

    private ValidationResult evaluateCustomMessage(ValidationResult result, ValidationContext validationContext) {
        String customMessage = validationContext.getOptions().getMessage();
        return StringUtils.isBlank((CharSequence)customMessage) ? result : ImmutableValidationResult.error(customMessage, result.getErrorType());
    }

    protected ValidationContext createContext(ValidationOptions options, ValidationExtension config) {
        return new ValidationContext(options, config);
    }

    protected Locale parseLocale(String locale) {
        locale = StringUtils.isBlank((CharSequence)locale) ? ValidationExtension.DEFAULT_LOCALE : locale;
        return new Locale(locale);
    }

    protected void logSuccessfulValidation(Validator validator) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully executed validator {}", (Object)ToStringBuilder.reflectionToString((Object)validator));
        }
    }
}

