/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extension.validation.internal.privileged;

/**
 * Sets {@link AllOperationExecutor} as the executor of the {@code all} operation
 *
 * @since 1.0
 */
public class AllOperationEnricher extends AggregateOperationEnricher {

  @Override
  String getOperationName() {
    return "all";
  }

  @Override
  AggregateOperationExecutor getOperationExecutor() {
    return new AllOperationExecutor();
  }
}
