/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.api.model;

import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.mule.api.annotation.NoImplement;
import org.mule.maven.client.api.model.Authentication;
import org.mule.maven.client.api.model.ImmutableRemoteRepository;
import org.mule.maven.client.api.model.RepositoryPolicy;

@NoImplement
public interface RemoteRepository {
    public String getId();

    public URL getUrl();

    public Optional<Authentication> getAuthentication();

    public Optional<RepositoryPolicy> getReleasePolicy();

    public Optional<RepositoryPolicy> getSnapshotPolicy();

    public static RemoteRepositoryBuilder newRemoteRepositoryBuilder() {
        return new RemoteRepositoryBuilder();
    }

    public static class RemoteRepositoryBuilder {
        private String id;
        private URL url;
        private Authentication authentication;
        private RepositoryPolicy releasePolicy;
        private RepositoryPolicy snapshotPolicy;

        public RemoteRepositoryBuilder id(String id) {
            Objects.requireNonNull(id, "id cannot be null");
            this.id = id;
            return this;
        }

        public RemoteRepositoryBuilder url(URL url) {
            Objects.requireNonNull(url, "remoteRepositoryUrl cannot be null");
            this.url = url;
            return this;
        }

        public RemoteRepositoryBuilder authentication(Authentication authentication) {
            Objects.requireNonNull(authentication, "authentication cannot be null");
            this.authentication = authentication;
            return this;
        }

        public RemoteRepositoryBuilder releasePolicy(RepositoryPolicy releasePolicy) {
            Objects.requireNonNull(releasePolicy, "releasePolicy cannot be null");
            this.releasePolicy = releasePolicy;
            return this;
        }

        public RemoteRepositoryBuilder snapshotPolicy(RepositoryPolicy snapshotPolicy) {
            Objects.requireNonNull(snapshotPolicy, "snapshotPolicy cannot be null");
            this.snapshotPolicy = snapshotPolicy;
            return this;
        }

        public RemoteRepository build() {
            return new ImmutableRemoteRepository(this.id, this.url, Optional.ofNullable(this.authentication), this.releasePolicy, this.snapshotPolicy);
        }
    }
}

