/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.internal.impl.slf4j.Slf4jLoggerFactory;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.wagon.WagonConfigurator;
import org.eclipse.aether.transport.wagon.WagonProvider;
import org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.JavaDependencyContextRefiner;
import org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.mule.maven.client.internal.AetherServiceRegister;
import org.mule.maven.client.internal.ApiDependencyGraphTransformer;
import org.mule.maven.client.internal.ArtifactRestorerTransformer;
import org.mule.maven.client.internal.DefaultModelResolver;
import org.mule.maven.client.internal.MuleDomainDependencyGraphTransformer;
import org.mule.maven.client.internal.MulePluginDependencyGraphTransformer;
import org.mule.maven.client.internal.MuleVersionSelector;
import org.mule.maven.client.internal.OneInstancePerNodeGraphTransformer;
import org.mule.maven.client.internal.dependency.PluginAwareExclusionDependencySelector;
import org.mule.maven.client.internal.wagon.SimplePlexusWagonConfigurator;
import org.mule.maven.client.internal.wagon.SimplePlexusWagonProvider;
import org.slf4j.Logger;

public class AetherRepositoryState {
    private static final Logger LOGGER = org.slf4j.LoggerFactory.getLogger(AetherRepositoryState.class);
    private DefaultServiceLocator locator;
    private DefaultRepositorySystemSession session;
    private RepositorySystem system;

    public AetherRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, Map<String, Object> serverConfigurations, boolean noSnapshotUpdates, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<Properties> userProperties, Consumer<DefaultRepositorySystemSession> sessionConfigurator) {
        this(localRepositoryFolder, workspaceReader, offline, ignoreArtifactDescriptorRepositories, authenticationSelector, proxySelector, mirrorSelector, serverConfigurations, noSnapshotUpdates, false, userProperties, sessionConfigurator, null);
    }

    public AetherRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, Map<String, Object> serverConfigurations, boolean noSnapshotUpdates, boolean updateSnapshots, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<Properties> userProperties, Consumer<DefaultRepositorySystemSession> sessionConfigurator, String globalChecksumPolicy) {
        this(localRepositoryFolder, workspaceReader, offline, ignoreArtifactDescriptorRepositories, authenticationSelector, proxySelector, mirrorSelector, serverConfigurations, noSnapshotUpdates, updateSnapshots, userProperties, sessionConfigurator, globalChecksumPolicy);
    }

    private AetherRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, Map<String, Object> serverConfigurations, boolean noSnapshotUpdates, boolean updateSnapshots, Optional<Properties> userProperties, Consumer<DefaultRepositorySystemSession> sessionConfigurator, String globalChecksumPolicy) {
        this.createRepositorySession(localRepositoryFolder, workspaceReader, offline, ignoreArtifactDescriptorRepositories, authenticationSelector, proxySelector, mirrorSelector, serverConfigurations, noSnapshotUpdates, updateSnapshots, userProperties, sessionConfigurator, globalChecksumPolicy);
    }

    public AetherRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, boolean noSnapshotUpdates, boolean updateSnapshots, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<Properties> userProperties, Consumer<DefaultRepositorySystemSession> sessionConfigurator, String globalChecksumPolicy) {
        this(localRepositoryFolder, workspaceReader, offline, ignoreArtifactDescriptorRepositories, authenticationSelector, proxySelector, mirrorSelector, Collections.emptyMap(), noSnapshotUpdates, updateSnapshots, userProperties, sessionConfigurator, globalChecksumPolicy);
    }

    private void createRepositorySession(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, Map<String, Object> serverConfigurations, boolean noSnapshotUpdates, boolean updateSnapshots, Optional<Properties> userProperties, Consumer<DefaultRepositorySystemSession> sessionConfigurator, String globalChecksumPolicy) {
        this.session = AetherRepositoryState.newDefaultRepositorySystemSession(noSnapshotUpdates, updateSnapshots, sessionConfigurator, globalChecksumPolicy, serverConfigurations);
        RepositorySystem repositorySystem = this.createRepositorySystem();
        this.session.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)this.session, new LocalRepository(localRepositoryFolder)));
        this.session.setOffline(offline);
        this.session.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
        proxySelector.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)this.session).setProxySelector(arg_0));
        mirrorSelector.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)this.session).setMirrorSelector(arg_0));
        authenticationSelector.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)this.session).setAuthenticationSelector(arg_0));
        ConflictResolver transformer = new ConflictResolver((ConflictResolver.VersionSelector)new MuleVersionSelector(new NearestVersionSelector()), (ConflictResolver.ScopeSelector)new JavaScopeSelector(), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new JavaScopeDeriver());
        ArrayList<Object> graphTransformers = new ArrayList<Object>();
        graphTransformers.add(new OneInstancePerNodeGraphTransformer());
        graphTransformers.add(new MuleDomainDependencyGraphTransformer());
        graphTransformers.add(new ApiDependencyGraphTransformer());
        graphTransformers.add(new MulePluginDependencyGraphTransformer());
        graphTransformers.add(transformer);
        graphTransformers.add(new JavaDependencyContextRefiner());
        graphTransformers.add(new ArtifactRestorerTransformer());
        this.session.setDependencyGraphTransformer((DependencyGraphTransformer)new ChainedDependencyGraphTransformer(graphTransformers.toArray(new DependencyGraphTransformer[0])));
        AndDependencySelector dependencySelector = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test", "provided"}), new OptionalDependencySelector(), new PluginAwareExclusionDependencySelector((DependencySelector)new ExclusionDependencySelector())});
        this.session.setDependencySelector((DependencySelector)dependencySelector);
        this.session.setArtifactDescriptorPolicy((session, request) -> 0);
        this.session.setIgnoreArtifactDescriptorRepositories(ignoreArtifactDescriptorRepositories);
        workspaceReader.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)this.session).setWorkspaceReader(arg_0));
        userProperties.ifPresent(properties -> this.session.setUserProperties((Map)properties));
        this.system = repositorySystem;
    }

    private RepositorySystem createRepositorySystem() {
        this.locator = new DefaultServiceLocator();
        this.locator.addService(LoggerFactory.class, Slf4jLoggerFactory.class);
        this.locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        this.locator.addService(RepositorySystem.class, DefaultRepositorySystem.class);
        this.locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        this.locator.addService(WagonProvider.class, SimplePlexusWagonProvider.class);
        this.locator.addService(WagonConfigurator.class, SimplePlexusWagonConfigurator.class);
        this.locator.addService(TransporterFactory.class, WagonTransporterFactory.class);
        this.locator.addService(VersionResolver.class, DefaultVersionResolver.class);
        this.locator.addService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        this.locator.addService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        this.locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                LOGGER.warn("There was an error while creating an Aether service", exception);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(exception.getMessage(), exception);
                }
            }
        });
        this.loadAetherServiceRegister().ifPresent(aetherServiceRegister -> aetherServiceRegister.registerServices(this.locator));
        return (RepositorySystem)this.locator.getService(RepositorySystem.class);
    }

    private Optional<AetherServiceRegister> loadAetherServiceRegister() {
        Iterator<AetherServiceRegister> iterator = ServiceLoader.load(AetherServiceRegister.class, AetherServiceRegister.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            AetherServiceRegister serviceRegister = iterator.next();
            return Optional.of(serviceRegister);
        }
        return Optional.empty();
    }

    public DefaultRepositorySystemSession getSession() {
        return this.session;
    }

    public RepositorySystem getSystem() {
        return this.system;
    }

    public ModelResolver createModelResolver(List<RemoteRepository> repositories) {
        return new DefaultModelResolver(this.session, (ArtifactResolver)this.locator.getService(ArtifactResolver.class), (VersionRangeResolver)this.locator.getService(VersionRangeResolver.class), this.getRemoteRepositoryManager(), repositories);
    }

    private static DefaultRepositorySystemSession newDefaultRepositorySystemSession(boolean noUpdateSnapshots, boolean updateSnapshots, Consumer<DefaultRepositorySystemSession> sessionConfigurator, String globalChecksumPolicy, Map<String, Object> serverConfigurations) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(1));
        session.setCache((RepositoryCache)new DefaultRepositoryCache());
        if (noUpdateSnapshots) {
            session.setUpdatePolicy("never");
        } else if (updateSnapshots) {
            session.setUpdatePolicy("always");
        } else {
            session.setUpdatePolicy(null);
        }
        if (globalChecksumPolicy != null) {
            session.setChecksumPolicy(globalChecksumPolicy);
        }
        session.setTransferListener((TransferListener)new LoggingTransferListener());
        session.setConfigProperties(serverConfigurations);
        sessionConfigurator.accept(session);
        return session;
    }

    public void setWorkspaceReader(WorkspaceReader workspaceReader) {
        this.session.setWorkspaceReader(workspaceReader);
    }

    public RemoteRepositoryManager getRemoteRepositoryManager() {
        return (RemoteRepositoryManager)this.locator.getService(RemoteRepositoryManager.class);
    }

    private static final class LoggingTransferListener
    implements TransferListener {
        private LoggingTransferListener() {
        }

        public void transferSucceeded(TransferEvent event) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Transfer {} for '{}' from {}", new Object[]{event.getType(), event.getResource().getResourceName(), event.getResource().getRepositoryUrl()});
            }
        }

        public void transferStarted(TransferEvent event) throws TransferCancelledException {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Transfer {} for '{}'", (Object)event.getType(), (Object)event.getResource().getResourceName());
            }
        }

        public void transferProgressed(TransferEvent event) throws TransferCancelledException {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Transfer {} for '{}' ({}/{})", new Object[]{event.getType(), event.getResource().getResourceName(), FileUtils.byteCountToDisplaySize((long)event.getTransferredBytes()), FileUtils.byteCountToDisplaySize((long)event.getResource().getContentLength())});
            }
        }

        public void transferInitiated(TransferEvent event) throws TransferCancelledException {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Transfer {} for '{}'", (Object)event.getType(), (Object)event.getResource().getResourceName());
            }
        }

        public void transferFailed(TransferEvent event) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Transfer {} for '{}' ({})", new Object[]{event.getType(), event.getResource(), event.getException()});
            }
        }

        public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
            LOGGER.warn("Transfer {} for '{}' ({})", new Object[]{event.getType(), event.getResource(), event.getException()});
        }
    }
}

