/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.mule.maven.client.api.BundleDescriptorCreationException;
import org.mule.maven.client.internal.util.FileUtils;
import org.mule.maven.client.internal.util.Preconditions;

public class MavenUtils {
    private static final String META_INF = "META-INF";
    private static final String MULE_ARTIFACT_FOLDER = "META-INF" + File.separator + "mule-artifact";
    private static final String MULE_PLUGIN_POM = "pom.xml";

    public static URL getPomUrlFromJar(File artifactFile) {
        try {
            List<URL> jarMavenUrls = FileUtils.getUrlsWithinJar(artifactFile, "META-INF/maven");
            Optional<URL> pomUrl = jarMavenUrls.stream().filter(url -> url.toString().endsWith(MULE_PLUGIN_POM)).findAny();
            if (!pomUrl.isPresent()) {
                throw new RuntimeException(String.format("The file 'pom.xml' was missing while looking within the artifact %s (it should be placed under [META-INF/maven/${groupId}/${artifactId}/pom.xml])", artifactFile.getName()));
            }
            return pomUrl.get();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Model getPomModel(File artifact) {
        if (artifact.isDirectory()) {
            return MavenUtils.getPomModelFolder(artifact);
        }
        return MavenUtils.getPomModelFromJar(artifact);
    }

    private static Model getPomModelFolder(File artifactFolder) {
        File mulePluginPom = MavenUtils.lookupPomFromMavenLocation(artifactFolder);
        return MavenUtils.getPomModelFromFile(mulePluginPom);
    }

    private static Model getPomModelFromJar(File artifactFile) {
        String pomFilePath = MULE_ARTIFACT_FOLDER + File.separator + MULE_PLUGIN_POM;
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            return reader.read((InputStream)new ByteArrayInputStream(FileUtils.loadFileContentFrom(MavenUtils.getPomUrlFromJar(artifactFile)).get()));
        }
        catch (IOException | XmlPullParserException e) {
            throw new BundleDescriptorCreationException(String.format("There was an issue reading '%s' for the artifact '%s'", pomFilePath, artifactFile.getAbsolutePath()), e);
        }
    }

    public static Model getPomModelFromFile(File pomFile) {
        Model model;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (FileReader mulePluginPomFilerReader = new FileReader(pomFile);){
            model = reader.read((Reader)mulePluginPomFilerReader);
        }
        catch (IOException | XmlPullParserException e) {
            throw new BundleDescriptorCreationException(String.format("There was an issue reading '%s' in '%s'", pomFile.getName(), pomFile.getParentFile().getAbsolutePath()), e);
        }
        return model;
    }

    private static File lookupPomFromMavenLocation(File artifactFolder) {
        File mulePluginPom = null;
        File lookupFolder = new File(artifactFolder, META_INF + File.separator + "maven");
        while (lookupFolder != null && lookupFolder.exists()) {
            File possiblePomLocation = new File(lookupFolder, MULE_PLUGIN_POM);
            if (possiblePomLocation.exists()) {
                mulePluginPom = possiblePomLocation;
                break;
            }
            File[] directories = lookupFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
            Preconditions.checkState(directories != null || directories.length == 0, String.format("No directories under %s so pom.xml file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            Preconditions.checkState(directories.length == 1, String.format("More than one directory under %s so pom.xml file for artifact in folder %s could not be found", lookupFolder.getAbsolutePath(), artifactFolder.getAbsolutePath()));
            lookupFolder = directories[0];
        }
        if (mulePluginPom == null || !mulePluginPom.exists()) {
            throw new BundleDescriptorCreationException(String.format("The maven bundle loader requires the file pom.xml (error found while reading artifact '%s')", artifactFolder.getName()));
        }
        return mulePluginPom;
    }
}

