/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.auth.ntlm.av;

import java.util.LinkedList;
import java.util.List;
import org.mule.service.http.netty.impl.client.auth.ntlm.av.AvChannelBindings;
import org.mule.service.http.netty.impl.client.auth.ntlm.av.AvFlags;
import org.mule.service.http.netty.impl.client.auth.ntlm.av.AvPair;
import org.mule.service.http.netty.impl.client.auth.ntlm.av.AvSingleHost;
import org.mule.service.http.netty.impl.client.auth.ntlm.av.AvTargetName;
import org.mule.service.http.netty.impl.client.auth.ntlm.av.AvTimestamp;
import org.mule.service.http.netty.impl.client.auth.ntlm.smb.SMBUtil;

public class AvPairs {
    public static List<AvPair> decode(byte[] data) {
        LinkedList<AvPair> pairs = new LinkedList<AvPair>();
        int pos = 0;
        boolean foundEnd = false;
        while (pos + 4 <= data.length) {
            int avId = SMBUtil.readInt2(data, pos);
            int avLen = SMBUtil.readInt2(data, pos + 2);
            pos += 4;
            if (avId == 0) {
                if (avLen != 0) {
                    throw new RuntimeException("Invalid avLen for AvEOL");
                }
                foundEnd = true;
                break;
            }
            byte[] raw = new byte[avLen];
            System.arraycopy(data, pos, raw, 0, avLen);
            pairs.add(AvPairs.parseAvPair(avId, raw));
            pos += avLen;
        }
        if (!foundEnd) {
            throw new RuntimeException("Missing AvEOL");
        }
        return pairs;
    }

    private static AvPair parseAvPair(int avId, byte[] raw) {
        switch (avId) {
            case 6: {
                return new AvFlags(raw);
            }
            case 7: {
                return new AvTimestamp(raw);
            }
            case 9: {
                return new AvTargetName(raw);
            }
            case 8: {
                return new AvSingleHost(raw);
            }
            case 10: {
                return new AvChannelBindings(raw);
            }
        }
        return new AvPair(avId, raw);
    }

    public static boolean contains(List<AvPair> pairs, int type) {
        if (pairs == null) {
            return false;
        }
        for (AvPair p : pairs) {
            if (p.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static AvPair get(List<AvPair> pairs, int type) {
        for (AvPair p : pairs) {
            if (p.getType() != type) continue;
            return p;
        }
        return null;
    }

    public static void replace(List<AvPair> pairs, AvPair rep) {
        AvPairs.remove(pairs, rep.getType());
        pairs.add(rep);
    }

    public static void remove(List<AvPair> pairs, int type) {
        pairs.removeIf(p -> p.getType() == type);
    }

    public static byte[] encode(List<AvPair> pairs) {
        int size = 0;
        for (AvPair p : pairs) {
            size += 4 + p.getRaw().length;
        }
        byte[] enc = new byte[size += 4];
        int pos = 0;
        for (AvPair p : pairs) {
            byte[] raw = p.getRaw();
            SMBUtil.writeInt2(p.getType(), enc, pos);
            SMBUtil.writeInt2(raw.length, enc, pos + 2);
            System.arraycopy(raw, 0, enc, pos + 4, raw.length);
            pos += 4 + raw.length;
        }
        SMBUtil.writeInt2(0L, enc, pos);
        SMBUtil.writeInt2(0L, enc, pos + 2);
        return enc;
    }
}

