/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.utils.client;

import io.netty.handler.ssl.SslContext;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.ExecutionException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.rules.ExternalResource;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.netty.impl.util.SslContextHelper;

public class TestSSLNettyClientWithBouncyCastle
extends ExternalResource {
    private static final String PASS = "mulepassword";
    private final String host;
    private final int port;
    private NettyHttpClient httpClient;

    public TestSSLNettyClientWithBouncyCastle(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void after() {
        Security.removeProvider("BC");
        this.httpClient.stop();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void reHandshake() throws Exception {
        this.httpClient.stop();
        this.initializeClient();
    }

    public void before() throws Throwable {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        this.initializeClient();
    }

    private void initializeClient() throws Exception {
        TlsContextFactory tlsContextFactory = TlsContextFactory.builder().trustStorePath("trustStore").trustStorePassword(PASS).keyStorePath("clientKeystore").keyPassword(PASS).keyStorePassword(PASS).build();
        SslContext sslContext = SslContextHelper.sslContextForClient((TlsContextFactory)tlsContextFactory);
        this.httpClient = NettyHttpClient.builder().withSslContext(sslContext).build();
        this.httpClient.start();
    }

    public HttpResponse sendGet(String path) throws ExecutionException, InterruptedException {
        return this.sendGet(path, (MultiMap<String, String>)MultiMap.emptyMultiMap());
    }

    public HttpResponse sendGet(String path, MultiMap<String, String> headers) throws ExecutionException, InterruptedException {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().protocol(HttpProtocol.HTTP_1_1).method("GET").uri(this.buildUriString(path)).headers(headers)).build();
        return (HttpResponse)this.httpClient.sendAsync(request, HttpRequestOptions.builder().build()).get();
    }

    public HttpResponse sendPost(String path, String content) throws ExecutionException, InterruptedException {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().protocol(HttpProtocol.HTTP_1_1).method("POST").uri(this.buildUriString(path)).entity((HttpEntity)new StringHttpEntity(content))).build();
        return (HttpResponse)this.httpClient.sendAsync(request, HttpRequestOptions.builder().build()).get();
    }

    private String buildUriString(String path) {
        return String.format("https://%s:%d%s%s", this.host, this.port, path.startsWith("/") ? "" : "/", path);
    }

    public NettyHttpClient getNettyClient() {
        return this.httpClient;
    }
}

