/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.service.http.netty.impl.client.HttpClientConnectionManager;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class HttpClientConnectionManagerTestCase
extends AbstractMuleTestCase {
    private static final int TEST_PORT = 80;
    private HttpClientConnectionManager clientConnectionManager;
    private Supplier<HttpClientConfiguration> configurationSupplier;
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Before
    public void setUp() {
        this.clientConnectionManager = new HttpClientConnectionManager();
        this.configurationSupplier = (Supplier)Mockito.spy((Object)((Supplier)Mockito.mock(Supplier.class)));
        HttpClientConfiguration mockConfiguration = (HttpClientConfiguration)Mockito.spy((Object)((HttpClientConfiguration)Mockito.mock(HttpClientConfiguration.class)));
        Mockito.when((Object)this.configurationSupplier.get()).thenReturn((Object)mockConfiguration);
    }

    @Test
    public void getOrCreateClientReturnsSameInstanceIfCalledTwiceWithSameName() {
        HttpClient firstCallClient = this.clientConnectionManager.getOrCreateClient("ClientName", this.configurationSupplier);
        HttpClient secondCallClient = this.clientConnectionManager.getOrCreateClient("ClientName", this.configurationSupplier);
        MatcherAssert.assertThat((Object)secondCallClient, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)firstCallClient)));
    }

    @Test
    public void getOrCreateClientCallsConfigurationSupplierOnlyOnceIfCalledTwiceWithSameName() {
        this.clientConnectionManager.getOrCreateClient("ClientName", this.configurationSupplier);
        this.clientConnectionManager.getOrCreateClient("ClientName", this.configurationSupplier);
        ((Supplier)Mockito.verify(this.configurationSupplier, (VerificationMode)Mockito.times((int)1))).get();
    }

    @Test
    public void getOrCreateClientReturnsDifferentInstancesIfCalledTwiceWithDifferentNames() {
        HttpClient firstCallClient = this.clientConnectionManager.getOrCreateClient("SomeClientName", this.configurationSupplier);
        HttpClient secondCallClient = this.clientConnectionManager.getOrCreateClient("OtherClientName", this.configurationSupplier);
        MatcherAssert.assertThat((Object)secondCallClient, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)firstCallClient))));
    }

    @Test
    public void getOrCreateClientCallsConfigurationSupplierTwiceIfCalledTwiceWithDifferentNames() {
        this.clientConnectionManager.getOrCreateClient("SomeClientName", this.configurationSupplier);
        this.clientConnectionManager.getOrCreateClient("OtherClientName", this.configurationSupplier);
        ((Supplier)Mockito.verify(this.configurationSupplier, (VerificationMode)Mockito.times((int)2))).get();
    }

    @Test
    public void clientNameCantBeNull() {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Client name can't be null");
        this.clientConnectionManager.getOrCreateClient(null, this.configurationSupplier);
    }

    @Test
    public void suppliedConfigurationCantBeNull() {
        Mockito.when((Object)this.configurationSupplier.get()).thenReturn(null);
        this.expected.expect(MuleRuntimeException.class);
        this.expected.expectCause(Matchers.instanceOf(IllegalArgumentException.class));
        this.expected.expectMessage("java.lang.IllegalArgumentException: Client configuration can't be null");
        this.clientConnectionManager.getOrCreateClient("SomeName", this.configurationSupplier);
    }

    @Test
    public void testGetOrCreateClientWithTlsConfiguration() throws Exception {
        this.configurationSupplier = (Supplier)Mockito.spy(Supplier.class);
        HttpClientConfiguration mockConfiguration = (HttpClientConfiguration)Mockito.mock(HttpClientConfiguration.class);
        Mockito.when((Object)this.configurationSupplier.get()).thenReturn((Object)mockConfiguration);
        TlsContextFactory tlsContextFactory = this.buildSetupTlsContextFactory(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"}, new String[]{"TLSv1.2", "TLSv1.3"});
        Mockito.when((Object)mockConfiguration.getTlsContextFactory()).thenReturn((Object)tlsContextFactory);
        HttpClient client = this.clientConnectionManager.getOrCreateClient("ClientName", this.configurationSupplier);
        Assert.assertNotNull((Object)client);
        ((Supplier)Mockito.verify(this.configurationSupplier, (VerificationMode)Mockito.times((int)1))).get();
    }

    @Test
    public void testValidClientConfiguration() throws Exception {
        TlsContextFactory tlsContextFactory = this.buildSetupTlsContextFactory(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"}, new String[]{"TLSv1.2", "TLSv1.3"});
        HttpClientConfiguration clientConfig = (HttpClientConfiguration)Mockito.mock(HttpClientConfiguration.class);
        Mockito.when((Object)clientConfig.getTlsContextFactory()).thenReturn((Object)tlsContextFactory);
        HttpClientConnectionManager manager = new HttpClientConnectionManager();
        HttpClient client = manager.getOrCreateClient("TestClient", () -> clientConfig);
        Assert.assertNotNull((Object)client);
        ((HttpClientConfiguration)Mockito.verify((Object)clientConfig, (VerificationMode)Mockito.times((int)1))).getTlsContextFactory();
        ((TlsContextFactory)Mockito.verify((Object)tlsContextFactory, (VerificationMode)Mockito.times((int)1))).getEnabledCipherSuites();
        ((TlsContextFactory)Mockito.verify((Object)tlsContextFactory, (VerificationMode)Mockito.times((int)1))).getEnabledProtocols();
    }

    @Test
    public void testNullConfiguration() {
        HttpClientConnectionManager manager = new HttpClientConnectionManager();
        Assert.assertThrows(MuleRuntimeException.class, () -> manager.getOrCreateClient("TestClient", () -> null));
    }

    @Test
    public void testSslContextCreationException() throws Exception {
        TlsContextFactory tlsContextFactory = (TlsContextFactory)Mockito.mock(TlsContextFactory.class);
        Mockito.when((Object)tlsContextFactory.createSslContext()).thenThrow(new Throwable[]{new KeyManagementException("SSL Context Error")});
        HttpClientConfiguration clientConfig = (HttpClientConfiguration)Mockito.mock(HttpClientConfiguration.class);
        Mockito.when((Object)clientConfig.getTlsContextFactory()).thenReturn((Object)tlsContextFactory);
        HttpClientConnectionManager manager = new HttpClientConnectionManager();
        Assert.assertThrows(MuleRuntimeException.class, () -> manager.getOrCreateClient("TestClient", () -> clientConfig));
    }

    @Test
    public void testSchedulerCreation() throws InitialisationException {
        SchedulerService schedulerService = (SchedulerService)Mockito.mock(SchedulerService.class);
        Mockito.when((Object)schedulerService.customScheduler((SchedulerConfig)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenReturn((Object)((Scheduler)Mockito.mock(Scheduler.class)));
        HttpClientConnectionManager manager = new HttpClientConnectionManager(schedulerService);
        manager.initialise();
        HttpClientConfiguration clientConfig = (HttpClientConfiguration)Mockito.mock(HttpClientConfiguration.class);
        HttpClient client = manager.getOrCreateClient("TestClient", () -> clientConfig);
        Assert.assertNotNull((Object)client);
        ((SchedulerService)Mockito.verify((Object)schedulerService)).customScheduler((SchedulerConfig)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
    }

    @Test
    public void testCipherSuitePreservedWhenNotSupported() throws Exception {
        SSLContext realSSLContext = SSLContext.getInstance("TLS");
        realSSLContext.init(null, null, new SecureRandom());
        TlsContextFactory tlsContextFactory = this.buildSetupTlsContextFactory(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"}, new String[]{"TLSv1.2", "TLSv1.3"});
        HttpClientConfiguration clientConfig = (HttpClientConfiguration)Mockito.mock(HttpClientConfiguration.class);
        Mockito.when((Object)clientConfig.getTlsContextFactory()).thenReturn((Object)tlsContextFactory);
        TlsContextFactory serverTlsContextFactory = this.buildSetupTlsContextFactory(new String[]{"NonSupportedCipherSuite"}, new String[]{"NonSupportedProtocol"});
        HttpClientConfiguration serverConfig = (HttpClientConfiguration)Mockito.mock(HttpClientConfiguration.class);
        Mockito.when((Object)serverConfig.getTlsContextFactory()).thenReturn((Object)serverTlsContextFactory);
        HttpClient client = this.clientConnectionManager.getOrCreateClient("ClientName", () -> clientConfig);
        HttpClient server = this.clientConnectionManager.getOrCreateClient("ServerName", () -> serverConfig);
        Assert.assertNotNull((Object)client);
        Assert.assertNotNull((Object)server);
        Assert.assertArrayEquals((Object[])new String[]{"NonSupportedCipherSuite"}, (Object[])serverConfig.getTlsContextFactory().getEnabledCipherSuites());
        Assert.assertArrayEquals((Object[])new String[]{"NonSupportedProtocol"}, (Object[])serverConfig.getTlsContextFactory().getEnabledProtocols());
        ((TlsContextFactory)Mockito.verify((Object)serverConfig.getTlsContextFactory(), (VerificationMode)Mockito.times((int)2))).getEnabledCipherSuites();
        ((TlsContextFactory)Mockito.verify((Object)serverConfig.getTlsContextFactory(), (VerificationMode)Mockito.times((int)2))).getEnabledProtocols();
    }

    @Test
    public void testMultipleClientsWithDifferentConfigurations() throws Exception {
        TlsContextFactory clientTlsContextFactory1 = this.buildSetupTlsContextFactory(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"}, new String[]{"TLSv1.2"});
        HttpClientConfiguration clientConfig1 = (HttpClientConfiguration)Mockito.mock(HttpClientConfiguration.class);
        Mockito.when((Object)clientConfig1.getTlsContextFactory()).thenReturn((Object)clientTlsContextFactory1);
        TlsContextFactory clientTlsContextFactory2 = this.buildSetupTlsContextFactory(new String[]{"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"}, new String[]{"TLSv1.3"});
        HttpClientConfiguration clientConfig2 = (HttpClientConfiguration)Mockito.mock(HttpClientConfiguration.class);
        Mockito.when((Object)clientConfig2.getTlsContextFactory()).thenReturn((Object)clientTlsContextFactory2);
        HttpClientConnectionManager manager = new HttpClientConnectionManager();
        HttpClient client1 = manager.getOrCreateClient("Client1", () -> clientConfig1);
        HttpClient client2 = manager.getOrCreateClient("Client2", () -> clientConfig2);
        Assert.assertNotNull((Object)client1);
        Assert.assertNotNull((Object)client2);
        Assert.assertNotSame((Object)client1, (Object)client2);
        ((HttpClientConfiguration)Mockito.verify((Object)clientConfig1)).getTlsContextFactory();
        ((TlsContextFactory)Mockito.verify((Object)clientTlsContextFactory1)).getEnabledCipherSuites();
        ((TlsContextFactory)Mockito.verify((Object)clientTlsContextFactory1)).getEnabledProtocols();
        ((HttpClientConfiguration)Mockito.verify((Object)clientConfig2)).getTlsContextFactory();
        ((TlsContextFactory)Mockito.verify((Object)clientTlsContextFactory2)).getEnabledCipherSuites();
        ((TlsContextFactory)Mockito.verify((Object)clientTlsContextFactory2)).getEnabledProtocols();
    }

    private TlsContextFactory buildSetupTlsContextFactory(String[] cipherSuites, String[] protocols) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext realSSLContext = SSLContext.getInstance("TLS");
        realSSLContext.init(null, null, new SecureRandom());
        TlsContextFactory mockTlsContextFactory = (TlsContextFactory)Mockito.mock(TlsContextFactory.class);
        Mockito.when((Object)mockTlsContextFactory.getEnabledCipherSuites()).thenReturn((Object)cipherSuites);
        Mockito.when((Object)mockTlsContextFactory.getEnabledProtocols()).thenReturn((Object)protocols);
        Mockito.when((Object)mockTlsContextFactory.createSslContext()).thenReturn((Object)realSSLContext);
        return mockTlsContextFactory;
    }
}

